/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../../../base/Page');
import Response = require('../../../../../http/response');
import V1 = require('../../../V1');
import { SerializableClass } from '../../../../../interfaces';

/**
 * Initialize the HighriskSpecialPrefixList
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @param version - Version of the resource
 * @param isoCode - The ISO country code
 */
declare function HighriskSpecialPrefixList(version: V1, isoCode: string): HighriskSpecialPrefixListInstance;

interface HighriskSpecialPrefixListInstance {
  /**
   * Streams HighriskSpecialPrefixInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Function to process each record
   */
  each(opts?: HighriskSpecialPrefixListInstanceEachOptions, callback?: (item: HighriskSpecialPrefixInstance, done: (err?: Error) => void) => void): void;
  /**
   * Retrieve a single target page of HighriskSpecialPrefixInstance records from the
   * API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param targetUrl - API-generated URL for the requested results page
   * @param callback - Callback to handle list of records
   */
  getPage(targetUrl?: string, callback?: (error: Error | null, items: HighriskSpecialPrefixPage) => any): Promise<HighriskSpecialPrefixPage>;
  /**
   * Lists HighriskSpecialPrefixInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  list(opts?: HighriskSpecialPrefixListInstanceOptions, callback?: (error: Error | null, items: HighriskSpecialPrefixInstance[]) => any): Promise<HighriskSpecialPrefixInstance[]>;
  /**
   * Retrieve a single page of HighriskSpecialPrefixInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  page(opts?: HighriskSpecialPrefixListInstancePageOptions, callback?: (error: Error | null, items: HighriskSpecialPrefixPage) => any): Promise<HighriskSpecialPrefixPage>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to each
 *
 * @property callback -
 *                         Function to process each record. If this and a positional
 *                         callback are passed, this one will be used
 * @property done - Function to be called upon completion of streaming
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         each() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no pageSize is defined but a limit is defined,
 *                         each() will attempt to read the limit with the most efficient
 *                         page size, i.e. min(limit, 1000)
 */
interface HighriskSpecialPrefixListInstanceEachOptions {
  callback?: (item: HighriskSpecialPrefixInstance, done: (err?: Error) => void) => void;
  done?: Function;
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to list
 *
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         list() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no page_size is defined but a limit is defined,
 *                         list() will attempt to read the limit with the most
 *                         efficient page size, i.e. min(limit, 1000)
 */
interface HighriskSpecialPrefixListInstanceOptions {
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to page
 *
 * @property pageNumber - Page Number, this value is simply for client state
 * @property pageSize - Number of records to return, defaults to 50
 * @property pageToken - PageToken provided by the API
 */
interface HighriskSpecialPrefixListInstancePageOptions {
  pageNumber?: number;
  pageSize?: number;
  pageToken?: string;
}

interface HighriskSpecialPrefixPayload extends HighriskSpecialPrefixResource, Page.TwilioResponsePayload {
}

interface HighriskSpecialPrefixResource {
  prefix: string;
}

interface HighriskSpecialPrefixSolution {
  isoCode?: string;
}


declare class HighriskSpecialPrefixInstance extends SerializableClass {
  /**
   * Initialize the HighriskSpecialPrefixContext
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param isoCode - The ISO country code
   */
  constructor(version: V1, payload: HighriskSpecialPrefixPayload, isoCode: string);

  prefix: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class HighriskSpecialPrefixPage extends Page<V1, HighriskSpecialPrefixPayload, HighriskSpecialPrefixResource, HighriskSpecialPrefixInstance> {
  /**
   * Initialize the HighriskSpecialPrefixPage
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: HighriskSpecialPrefixSolution);

  /**
   * Build an instance of HighriskSpecialPrefixInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: HighriskSpecialPrefixPayload): HighriskSpecialPrefixInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { HighriskSpecialPrefixInstance, HighriskSpecialPrefixList, HighriskSpecialPrefixListInstance, HighriskSpecialPrefixListInstanceEachOptions, HighriskSpecialPrefixListInstanceOptions, HighriskSpecialPrefixListInstancePageOptions, HighriskSpecialPrefixPage, HighriskSpecialPrefixPayload, HighriskSpecialPrefixResource, HighriskSpecialPrefixSolution }
