/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../base/Page');
import Response = require('../../../http/response');
import V1 = require('../V1');
import serialize = require('../../../base/serialize');
import { SerializableClass } from '../../../interfaces';

type CompositionHookFormat = 'mp4'|'webm';

/**
 * Initialize the CompositionHookList
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @param version - Version of the resource
 */
declare function CompositionHookList(version: V1): CompositionHookListInstance;

/**
 * Options to pass to update
 *
 * @property audioSources - An array of track names from the same group room to merge
 * @property audioSourcesExcluded - An array of track names to exclude
 * @property enabled - Whether the composition hook is active
 * @property format - The container format of the media files used by the compositions created by the composition hook
 * @property friendlyName - A unique string to describe the resource
 * @property resolution - A string that describes the columns (width) and rows (height) of the generated composed video in pixels
 * @property statusCallback - The URL we should call to send status information to your application
 * @property statusCallbackMethod - The HTTP method we should use to call status_callback
 * @property trim - Whether to clip the intervals where there is no active media in the Compositions triggered by the composition hook
 * @property videoLayout - A JSON object that describes the video layout of the composition hook
 */
interface CompositionHookInstanceUpdateOptions {
  audioSources?: string | string[];
  audioSourcesExcluded?: string | string[];
  enabled?: boolean;
  format?: CompositionHookFormat;
  friendlyName: string;
  resolution?: string;
  statusCallback?: string;
  statusCallbackMethod?: string;
  trim?: boolean;
  videoLayout?: object;
}

interface CompositionHookListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): CompositionHookContext;
  /**
   * create a CompositionHookInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  create(opts: CompositionHookListInstanceCreateOptions, callback?: (error: Error | null, item: CompositionHookInstance) => any): Promise<CompositionHookInstance>;
  /**
   * Streams CompositionHookInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Function to process each record
   */
  each(opts?: CompositionHookListInstanceEachOptions, callback?: (item: CompositionHookInstance, done: (err?: Error) => void) => void): void;
  /**
   * Constructs a composition_hook
   *
   * @param sid - The SID that identifies the resource to fetch
   */
  get(sid: string): CompositionHookContext;
  /**
   * Retrieve a single target page of CompositionHookInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param targetUrl - API-generated URL for the requested results page
   * @param callback - Callback to handle list of records
   */
  getPage(targetUrl?: string, callback?: (error: Error | null, items: CompositionHookPage) => any): Promise<CompositionHookPage>;
  /**
   * Lists CompositionHookInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  list(opts?: CompositionHookListInstanceOptions, callback?: (error: Error | null, items: CompositionHookInstance[]) => any): Promise<CompositionHookInstance[]>;
  /**
   * Retrieve a single page of CompositionHookInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  page(opts?: CompositionHookListInstancePageOptions, callback?: (error: Error | null, items: CompositionHookPage) => any): Promise<CompositionHookPage>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to create
 *
 * @property audioSources - An array of track names from the same group room to merge
 * @property audioSourcesExcluded - An array of track names to exclude
 * @property enabled - Whether the composition hook is active
 * @property format - The container format of the media files used by the compositions created by the composition hook
 * @property friendlyName - A unique string to describe the resource
 * @property resolution - A string that describes the rows (width) and columns (height) of the generated composed video in pixels
 * @property statusCallback - The URL we should call to send status information to your application
 * @property statusCallbackMethod - The HTTP method we should use to call status_callback
 * @property trim - Whether to clip the intervals where there is no active media in the Compositions triggered by the composition hook
 * @property videoLayout - An object that describes the video layout of the composition hook
 */
interface CompositionHookListInstanceCreateOptions {
  audioSources?: string | string[];
  audioSourcesExcluded?: string | string[];
  enabled?: boolean;
  format?: CompositionHookFormat;
  friendlyName: string;
  resolution?: string;
  statusCallback?: string;
  statusCallbackMethod?: string;
  trim?: boolean;
  videoLayout?: object;
}

/**
 * Options to pass to each
 *
 * @property callback -
 *                         Function to process each record. If this and a positional
 *                         callback are passed, this one will be used
 * @property dateCreatedAfter - Read only CompositionHook resources created on or after this ISO 8601 datetime with time zone
 * @property dateCreatedBefore - Read only CompositionHook resources created before this ISO 8601 datetime with time zone
 * @property done - Function to be called upon completion of streaming
 * @property enabled - Read only CompositionHook resources with an enabled value that matches this parameter
 * @property friendlyName - Read only CompositionHook resources with friendly names that match this string
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         each() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no pageSize is defined but a limit is defined,
 *                         each() will attempt to read the limit with the most efficient
 *                         page size, i.e. min(limit, 1000)
 */
interface CompositionHookListInstanceEachOptions {
  callback?: (item: CompositionHookInstance, done: (err?: Error) => void) => void;
  dateCreatedAfter?: Date;
  dateCreatedBefore?: Date;
  done?: Function;
  enabled?: boolean;
  friendlyName?: string;
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to list
 *
 * @property dateCreatedAfter - Read only CompositionHook resources created on or after this ISO 8601 datetime with time zone
 * @property dateCreatedBefore - Read only CompositionHook resources created before this ISO 8601 datetime with time zone
 * @property enabled - Read only CompositionHook resources with an enabled value that matches this parameter
 * @property friendlyName - Read only CompositionHook resources with friendly names that match this string
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         list() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no page_size is defined but a limit is defined,
 *                         list() will attempt to read the limit with the most
 *                         efficient page size, i.e. min(limit, 1000)
 */
interface CompositionHookListInstanceOptions {
  dateCreatedAfter?: Date;
  dateCreatedBefore?: Date;
  enabled?: boolean;
  friendlyName?: string;
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to page
 *
 * @property dateCreatedAfter - Read only CompositionHook resources created on or after this ISO 8601 datetime with time zone
 * @property dateCreatedBefore - Read only CompositionHook resources created before this ISO 8601 datetime with time zone
 * @property enabled - Read only CompositionHook resources with an enabled value that matches this parameter
 * @property friendlyName - Read only CompositionHook resources with friendly names that match this string
 * @property pageNumber - Page Number, this value is simply for client state
 * @property pageSize - Number of records to return, defaults to 50
 * @property pageToken - PageToken provided by the API
 */
interface CompositionHookListInstancePageOptions {
  dateCreatedAfter?: Date;
  dateCreatedBefore?: Date;
  enabled?: boolean;
  friendlyName?: string;
  pageNumber?: number;
  pageSize?: number;
  pageToken?: string;
}

interface CompositionHookPayload extends CompositionHookResource, Page.TwilioResponsePayload {
}

interface CompositionHookResource {
  account_sid: string;
  audio_sources: string[];
  audio_sources_excluded: string[];
  date_created: Date;
  date_updated: Date;
  enabled: boolean;
  format: CompositionHookFormat;
  friendly_name: string;
  resolution: string;
  sid: string;
  status_callback: string;
  status_callback_method: string;
  trim: boolean;
  url: string;
  video_layout: object;
}

interface CompositionHookSolution {
}


declare class CompositionHookContext {
  /**
   * Initialize the CompositionHookContext
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param sid - The SID that identifies the resource to fetch
   */
  constructor(version: V1, sid: string);

  /**
   * fetch a CompositionHookInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: CompositionHookInstance) => any): Promise<CompositionHookInstance>;
  /**
   * remove a CompositionHookInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: CompositionHookInstance) => any): Promise<boolean>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a CompositionHookInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts: CompositionHookInstanceUpdateOptions, callback?: (error: Error | null, items: CompositionHookInstance) => any): Promise<CompositionHookInstance>;
}


declare class CompositionHookInstance extends SerializableClass {
  /**
   * Initialize the CompositionHookContext
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param sid - The SID that identifies the resource to fetch
   */
  constructor(version: V1, payload: CompositionHookPayload, sid: string);

  private _proxy: CompositionHookContext;
  accountSid: string;
  audioSources: string[];
  audioSourcesExcluded: string[];
  dateCreated: Date;
  dateUpdated: Date;
  enabled: boolean;
  /**
   * fetch a CompositionHookInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: CompositionHookInstance) => any): Promise<CompositionHookInstance>;
  format: CompositionHookFormat;
  friendlyName: string;
  /**
   * remove a CompositionHookInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: CompositionHookInstance) => any): Promise<boolean>;
  resolution: string;
  sid: string;
  statusCallback: string;
  statusCallbackMethod: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  trim: boolean;
  /**
   * update a CompositionHookInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts: CompositionHookInstanceUpdateOptions, callback?: (error: Error | null, items: CompositionHookInstance) => any): Promise<CompositionHookInstance>;
  url: string;
  videoLayout: object;
}


declare class CompositionHookPage extends Page<V1, CompositionHookPayload, CompositionHookResource, CompositionHookInstance> {
  /**
   * Initialize the CompositionHookPage
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: CompositionHookSolution);

  /**
   * Build an instance of CompositionHookInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: CompositionHookPayload): CompositionHookInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { CompositionHookContext, CompositionHookFormat, CompositionHookInstance, CompositionHookInstanceUpdateOptions, CompositionHookList, CompositionHookListInstance, CompositionHookListInstanceCreateOptions, CompositionHookListInstanceEachOptions, CompositionHookListInstanceOptions, CompositionHookListInstancePageOptions, CompositionHookPage, CompositionHookPayload, CompositionHookResource, CompositionHookSolution }
