/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../../base/Page');
import Response = require('../../../../http/response');
import V2 = require('../../V2');
import { BucketList } from './rateLimit/bucket';
import { BucketListInstance } from './rateLimit/bucket';
import { SerializableClass } from '../../../../interfaces';

/**
 * Initialize the RateLimitList
 *
 * @param version - Version of the resource
 * @param serviceSid - The SID of the Service that the resource is associated with
 */
declare function RateLimitList(version: V2, serviceSid: string): RateLimitListInstance;

/**
 * Options to pass to update
 *
 * @property description - Description of this Rate Limit
 */
interface RateLimitInstanceUpdateOptions {
  description?: string;
}

interface RateLimitListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): RateLimitContext;
  /**
   * create a RateLimitInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  create(opts: RateLimitListInstanceCreateOptions, callback?: (error: Error | null, item: RateLimitInstance) => any): Promise<RateLimitInstance>;
  /**
   * Streams RateLimitInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Function to process each record
   */
  each(opts?: RateLimitListInstanceEachOptions, callback?: (item: RateLimitInstance, done: (err?: Error) => void) => void): void;
  /**
   * Constructs a rate_limit
   *
   * @param sid - The unique string that identifies the resource
   */
  get(sid: string): RateLimitContext;
  /**
   * Retrieve a single target page of RateLimitInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param targetUrl - API-generated URL for the requested results page
   * @param callback - Callback to handle list of records
   */
  getPage(targetUrl?: string, callback?: (error: Error | null, items: RateLimitPage) => any): Promise<RateLimitPage>;
  /**
   * Lists RateLimitInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  list(opts?: RateLimitListInstanceOptions, callback?: (error: Error | null, items: RateLimitInstance[]) => any): Promise<RateLimitInstance[]>;
  /**
   * Retrieve a single page of RateLimitInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  page(opts?: RateLimitListInstancePageOptions, callback?: (error: Error | null, items: RateLimitPage) => any): Promise<RateLimitPage>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to create
 *
 * @property description - Description of this Rate Limit
 * @property uniqueName - A unique, developer assigned name of this Rate Limit.
 */
interface RateLimitListInstanceCreateOptions {
  description?: string;
  uniqueName: string;
}

/**
 * Options to pass to each
 *
 * @property callback -
 *                         Function to process each record. If this and a positional
 *                         callback are passed, this one will be used
 * @property done - Function to be called upon completion of streaming
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         each() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no pageSize is defined but a limit is defined,
 *                         each() will attempt to read the limit with the most efficient
 *                         page size, i.e. min(limit, 1000)
 */
interface RateLimitListInstanceEachOptions {
  callback?: (item: RateLimitInstance, done: (err?: Error) => void) => void;
  done?: Function;
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to list
 *
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         list() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no page_size is defined but a limit is defined,
 *                         list() will attempt to read the limit with the most
 *                         efficient page size, i.e. min(limit, 1000)
 */
interface RateLimitListInstanceOptions {
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to page
 *
 * @property pageNumber - Page Number, this value is simply for client state
 * @property pageSize - Number of records to return, defaults to 50
 * @property pageToken - PageToken provided by the API
 */
interface RateLimitListInstancePageOptions {
  pageNumber?: number;
  pageSize?: number;
  pageToken?: string;
}

interface RateLimitPayload extends RateLimitResource, Page.TwilioResponsePayload {
}

interface RateLimitResource {
  account_sid: string;
  date_created: Date;
  date_updated: Date;
  description: string;
  links: string;
  service_sid: string;
  sid: string;
  unique_name: string;
  url: string;
}

interface RateLimitSolution {
  serviceSid?: string;
}


declare class RateLimitContext {
  /**
   * Initialize the RateLimitContext
   *
   * @param version - Version of the resource
   * @param serviceSid - The SID of the Service that the resource is associated with
   * @param sid - The unique string that identifies the resource
   */
  constructor(version: V2, serviceSid: string, sid: string);

  buckets: BucketListInstance;
  /**
   * fetch a RateLimitInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: RateLimitInstance) => any): Promise<RateLimitInstance>;
  /**
   * remove a RateLimitInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: RateLimitInstance) => any): Promise<boolean>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a RateLimitInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: RateLimitInstanceUpdateOptions, callback?: (error: Error | null, items: RateLimitInstance) => any): Promise<RateLimitInstance>;
}


declare class RateLimitInstance extends SerializableClass {
  /**
   * Initialize the RateLimitContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param serviceSid - The SID of the Service that the resource is associated with
   * @param sid - The unique string that identifies the resource
   */
  constructor(version: V2, payload: RateLimitPayload, serviceSid: string, sid: string);

  private _proxy: RateLimitContext;
  accountSid: string;
  /**
   * Access the buckets
   */
  buckets(): BucketListInstance;
  dateCreated: Date;
  dateUpdated: Date;
  description: string;
  /**
   * fetch a RateLimitInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: RateLimitInstance) => any): Promise<RateLimitInstance>;
  links: string;
  /**
   * remove a RateLimitInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: RateLimitInstance) => any): Promise<boolean>;
  serviceSid: string;
  sid: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  uniqueName: string;
  /**
   * update a RateLimitInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: RateLimitInstanceUpdateOptions, callback?: (error: Error | null, items: RateLimitInstance) => any): Promise<RateLimitInstance>;
  url: string;
}


declare class RateLimitPage extends Page<V2, RateLimitPayload, RateLimitResource, RateLimitInstance> {
  /**
   * Initialize the RateLimitPage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V2, response: Response<string>, solution: RateLimitSolution);

  /**
   * Build an instance of RateLimitInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: RateLimitPayload): RateLimitInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { RateLimitContext, RateLimitInstance, RateLimitInstanceUpdateOptions, RateLimitList, RateLimitListInstance, RateLimitListInstanceCreateOptions, RateLimitListInstanceEachOptions, RateLimitListInstanceOptions, RateLimitListInstancePageOptions, RateLimitPage, RateLimitPayload, RateLimitResource, RateLimitSolution }
