'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var Page = require('../../../../base/Page');  /* jshint ignore:line */
var deserialize = require(
    '../../../../base/deserialize');  /* jshint ignore:line */
var values = require('../../../../base/values');  /* jshint ignore:line */

var TerminatingSipDomainList;
var TerminatingSipDomainPage;
var TerminatingSipDomainInstance;
var TerminatingSipDomainContext;

/* jshint ignore:start */
/**
 * Initialize the TerminatingSipDomainList
 *
 * @constructor Twilio.Trunking.V1.TrunkContext.TerminatingSipDomainList
 *
 * @param {Twilio.Trunking.V1} version - Version of the resource
 * @param {string} trunkSid - The SID of the Trunk to which we should route calls
 */
/* jshint ignore:end */
TerminatingSipDomainList = function TerminatingSipDomainList(version, trunkSid)
    {
  /* jshint ignore:start */
  /**
   * @function terminatingSipDomains
   * @memberof Twilio.Trunking.V1.TrunkContext#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Trunking.V1.TrunkContext.TerminatingSipDomainContext}
   */
  /* jshint ignore:end */
  function TerminatingSipDomainListInstance(sid) {
    return TerminatingSipDomainListInstance.get(sid);
  }

  TerminatingSipDomainListInstance._version = version;
  // Path Solution
  TerminatingSipDomainListInstance._solution = {trunkSid: trunkSid};
  TerminatingSipDomainListInstance._uri = `/Trunks/${trunkSid}/TerminatingSipDomains`;
  /* jshint ignore:start */
  /**
   * create a TerminatingSipDomainInstance
   *
   * @function create
   * @memberof Twilio.Trunking.V1.TrunkContext.TerminatingSipDomainList#
   *
   * @param {object} opts - Options for request
   * @param {string} opts.sipDomainSid -
   *          The SID of the SIP Domain to associate with the trunk
   * @param {function} [callback] - Callback to handle processed record
   *
   * @returns {Promise} Resolves to processed TerminatingSipDomainInstance
   */
  /* jshint ignore:end */
  TerminatingSipDomainListInstance.create = function create(opts, callback) {
    if (_.isUndefined(opts)) {
      throw new Error('Required parameter "opts" missing.');
    }
    if (_.isUndefined(opts.sipDomainSid)) {
      throw new Error('Required parameter "opts.sipDomainSid" missing.');
    }

    var deferred = Q.defer();
    var data = values.of({'SipDomainSid': _.get(opts, 'sipDomainSid')});

    var promise = this._version.create({uri: this._uri, method: 'POST', data: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new TerminatingSipDomainInstance(
        this._version,
        payload,
        this._solution.trunkSid,
        this._solution.sid
      ));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Streams TerminatingSipDomainInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function each
   * @memberof Twilio.Trunking.V1.TrunkContext.TerminatingSipDomainList#
   *
   * @param {object} [opts] - Options for request
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         each() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no pageSize is defined but a limit is defined,
   *         each() will attempt to read the limit with the most efficient
   *         page size, i.e. min(limit, 1000)
   * @param {Function} [opts.callback] -
   *         Function to process each record. If this and a positional
   *         callback are passed, this one will be used
   * @param {Function} [opts.done] -
   *          Function to be called upon completion of streaming
   * @param {Function} [callback] - Function to process each record
   */
  /* jshint ignore:end */
  TerminatingSipDomainListInstance.each = function each(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    if (opts.callback) {
      callback = opts.callback;
    }
    if (_.isUndefined(callback)) {
      throw new Error('Callback function must be provided');
    }

    var done = false;
    var currentPage = 1;
    var currentResource = 0;
    var limits = this._version.readLimits({
      limit: opts.limit,
      pageSize: opts.pageSize
    });

    function onComplete(error) {
      done = true;
      if (_.isFunction(opts.done)) {
        opts.done(error);
      }
    }

    function fetchNextPage(fn) {
      var promise = fn();
      if (_.isUndefined(promise)) {
        onComplete();
        return;
      }

      promise.then(function(page) {
        _.each(page.instances, function(instance) {
          if (done || (!_.isUndefined(opts.limit) && currentResource >= opts.limit)) {
            done = true;
            return false;
          }

          currentResource++;
          callback(instance, onComplete);
        });

        if ((limits.pageLimit && limits.pageLimit <= currentPage)) {
          onComplete();
        } else if (!done) {
          currentPage++;
          fetchNextPage(_.bind(page.nextPage, page));
        }
      });

      promise.catch(onComplete);
    }

    fetchNextPage(_.bind(this.page, this, _.merge(opts, limits)));
  };

  /* jshint ignore:start */
  /**
   * Lists TerminatingSipDomainInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function list
   * @memberof Twilio.Trunking.V1.TrunkContext.TerminatingSipDomainList#
   *
   * @param {object} [opts] - Options for request
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         list() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no page_size is defined but a limit is defined,
   *         list() will attempt to read the limit with the most
   *         efficient page size, i.e. min(limit, 1000)
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  TerminatingSipDomainListInstance.list = function list(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    var deferred = Q.defer();
    var allResources = [];
    opts.callback = function(resource, done) {
      allResources.push(resource);

      if (!_.isUndefined(opts.limit) && allResources.length === opts.limit) {
        done();
      }
    };

    opts.done = function(error) {
      if (_.isUndefined(error)) {
        deferred.resolve(allResources);
      } else {
        deferred.reject(error);
      }
    };

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    this.each(opts);
    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single page of TerminatingSipDomainInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function page
   * @memberof Twilio.Trunking.V1.TrunkContext.TerminatingSipDomainList#
   *
   * @param {object} [opts] - Options for request
   * @param {string} [opts.pageToken] - PageToken provided by the API
   * @param {number} [opts.pageNumber] -
   *          Page Number, this value is simply for client state
   * @param {number} [opts.pageSize] - Number of records to return, defaults to 50
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  TerminatingSipDomainListInstance.page = function page(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};

    var deferred = Q.defer();
    var data = values.of({
      'PageToken': opts.pageToken,
      'Page': opts.pageNumber,
      'PageSize': opts.pageSize
    });

    var promise = this._version.page({uri: this._uri, method: 'GET', params: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new TerminatingSipDomainPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single target page of TerminatingSipDomainInstance records from the
   * API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function getPage
   * @memberof Twilio.Trunking.V1.TrunkContext.TerminatingSipDomainList#
   *
   * @param {string} [targetUrl] - API-generated URL for the requested results page
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  TerminatingSipDomainListInstance.getPage = function getPage(targetUrl, callback)
                                                               {
    var deferred = Q.defer();

    var promise = this._version._domain.twilio.request({method: 'GET', uri: targetUrl});

    promise = promise.then(function(payload) {
      deferred.resolve(new TerminatingSipDomainPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Constructs a terminating_sip_domain
   *
   * @function get
   * @memberof Twilio.Trunking.V1.TrunkContext.TerminatingSipDomainList#
   *
   * @param {string} sid - The unique string that identifies the resource
   *
   * @returns {Twilio.Trunking.V1.TrunkContext.TerminatingSipDomainContext}
   */
  /* jshint ignore:end */
  TerminatingSipDomainListInstance.get = function get(sid) {
    return new TerminatingSipDomainContext(this._version, this._solution.trunkSid, sid);
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Trunking.V1.TrunkContext.TerminatingSipDomainList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  TerminatingSipDomainListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  TerminatingSipDomainListInstance[util.inspect.custom] = function inspect(depth,
      options) {
    return util.inspect(this.toJSON(), options);
  };

  return TerminatingSipDomainListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the TerminatingSipDomainPage
 *
 * @constructor Twilio.Trunking.V1.TrunkContext.TerminatingSipDomainPage
 *
 * @param {V1} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {TerminatingSipDomainSolution} solution - Path solution
 *
 * @returns TerminatingSipDomainPage
 */
/* jshint ignore:end */
TerminatingSipDomainPage = function TerminatingSipDomainPage(version, response,
    solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(TerminatingSipDomainPage.prototype, Page.prototype);
TerminatingSipDomainPage.prototype.constructor = TerminatingSipDomainPage;

/* jshint ignore:start */
/**
 * Build an instance of TerminatingSipDomainInstance
 *
 * @function getInstance
 * @memberof Twilio.Trunking.V1.TrunkContext.TerminatingSipDomainPage#
 *
 * @param {TerminatingSipDomainPayload} payload - Payload response from the API
 *
 * @returns TerminatingSipDomainInstance
 */
/* jshint ignore:end */
TerminatingSipDomainPage.prototype.getInstance = function getInstance(payload) {
  return new TerminatingSipDomainInstance(this._version, payload, this._solution.trunkSid);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Trunking.V1.TrunkContext.TerminatingSipDomainPage#
 *
 * @returns Object
 */
/* jshint ignore:end */
TerminatingSipDomainPage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

TerminatingSipDomainPage.prototype[util.inspect.custom] = function
    inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the TerminatingSipDomainContext
 *
 * @constructor Twilio.Trunking.V1.TrunkContext.TerminatingSipDomainInstance
 *
 * @property {string} accountSid - The SID of the Account that created the resource
 * @property {string} apiVersion - The API version used to process the call
 * @property {string} authType - The types of authentication mapped to the domain
 * @property {Date} dateCreated -
 *          The RFC 2822 date and time in GMT when the resource was created
 * @property {Date} dateUpdated -
 *          The RFC 2822 date and time in GMT when the resource was last updated
 * @property {string} domainName -
 *          The unique address you reserve on Twilio to which you route your SIP traffic
 * @property {string} friendlyName -
 *          The string that you assigned to describe the resource
 * @property {string} sid - The unique string that identifies the resource
 * @property {string} url - The absolute URL of the resource
 * @property {string} voiceFallbackMethod -
 *          The HTTP method used with voice_fallback_url
 * @property {string} voiceFallbackUrl -
 *          The URL that we call when an error occurs in executing TwiML
 * @property {string} voiceMethod - The HTTP method used with voice_url
 * @property {string} voiceStatusCallbackMethod -
 *          The HTTP method that we use to call the voice_status_callback_url
 * @property {string} voiceStatusCallbackUrl -
 *          The URL that we call to pass status parameters to your application
 * @property {string} voiceUrl - The URL we call when the domain receives a call
 * @property {boolean} sipRegistration -
 *          Whether SIP Endpoints can register with the domain to receive calls
 * @property {string} trunkSid -
 *          The SID of the Trunk to which we should route calls
 * @property {string} links - The URLs of related resources
 *
 * @param {V1} version - Version of the resource
 * @param {TerminatingSipDomainPayload} payload - The instance payload
 * @param {sid} trunkSid - The SID of the Trunk to which we should route calls
 * @param {sid} sid - The unique string that identifies the resource
 */
/* jshint ignore:end */
TerminatingSipDomainInstance = function TerminatingSipDomainInstance(version,
    payload, trunkSid, sid) {
  this._version = version;

  // Marshaled Properties
  this.accountSid = payload.account_sid; // jshint ignore:line
  this.apiVersion = payload.api_version; // jshint ignore:line
  this.authType = payload.auth_type; // jshint ignore:line
  this.dateCreated = deserialize.iso8601DateTime(payload.date_created); // jshint ignore:line
  this.dateUpdated = deserialize.iso8601DateTime(payload.date_updated); // jshint ignore:line
  this.domainName = payload.domain_name; // jshint ignore:line
  this.friendlyName = payload.friendly_name; // jshint ignore:line
  this.sid = payload.sid; // jshint ignore:line
  this.url = payload.url; // jshint ignore:line
  this.voiceFallbackMethod = payload.voice_fallback_method; // jshint ignore:line
  this.voiceFallbackUrl = payload.voice_fallback_url; // jshint ignore:line
  this.voiceMethod = payload.voice_method; // jshint ignore:line
  this.voiceStatusCallbackMethod = payload.voice_status_callback_method; // jshint ignore:line
  this.voiceStatusCallbackUrl = payload.voice_status_callback_url; // jshint ignore:line
  this.voiceUrl = payload.voice_url; // jshint ignore:line
  this.sipRegistration = payload.sip_registration; // jshint ignore:line
  this.trunkSid = payload.trunk_sid; // jshint ignore:line
  this.links = payload.links; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {trunkSid: trunkSid, sid: sid || this.sid, };
};

Object.defineProperty(TerminatingSipDomainInstance.prototype,
  '_proxy', {
    get: function() {
      if (!this._context) {
        this._context = new TerminatingSipDomainContext(
          this._version,
          this._solution.trunkSid,
          this._solution.sid
        );
      }

      return this._context;
    }
});

/* jshint ignore:start */
/**
 * fetch a TerminatingSipDomainInstance
 *
 * @function fetch
 * @memberof Twilio.Trunking.V1.TrunkContext.TerminatingSipDomainInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed TerminatingSipDomainInstance
 */
/* jshint ignore:end */
TerminatingSipDomainInstance.prototype.fetch = function fetch(callback) {
  return this._proxy.fetch(callback);
};

/* jshint ignore:start */
/**
 * remove a TerminatingSipDomainInstance
 *
 * @function remove
 * @memberof Twilio.Trunking.V1.TrunkContext.TerminatingSipDomainInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed TerminatingSipDomainInstance
 */
/* jshint ignore:end */
TerminatingSipDomainInstance.prototype.remove = function remove(callback) {
  return this._proxy.remove(callback);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Trunking.V1.TrunkContext.TerminatingSipDomainInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
TerminatingSipDomainInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

TerminatingSipDomainInstance.prototype[util.inspect.custom] = function
    inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the TerminatingSipDomainContext
 *
 * @constructor Twilio.Trunking.V1.TrunkContext.TerminatingSipDomainContext
 *
 * @param {V1} version - Version of the resource
 * @param {sid} trunkSid - The SID of the Trunk with the resource to fetch
 * @param {sid} sid - The unique string that identifies the resource
 */
/* jshint ignore:end */
TerminatingSipDomainContext = function TerminatingSipDomainContext(version,
    trunkSid, sid) {
  this._version = version;

  // Path Solution
  this._solution = {trunkSid: trunkSid, sid: sid, };
  this._uri = `/Trunks/${trunkSid}/TerminatingSipDomains/${sid}`;
};

/* jshint ignore:start */
/**
 * fetch a TerminatingSipDomainInstance
 *
 * @function fetch
 * @memberof Twilio.Trunking.V1.TrunkContext.TerminatingSipDomainContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed TerminatingSipDomainInstance
 */
/* jshint ignore:end */
TerminatingSipDomainContext.prototype.fetch = function fetch(callback) {
  var deferred = Q.defer();
  var promise = this._version.fetch({uri: this._uri, method: 'GET'});

  promise = promise.then(function(payload) {
    deferred.resolve(new TerminatingSipDomainInstance(
      this._version,
      payload,
      this._solution.trunkSid,
      this._solution.sid
    ));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * remove a TerminatingSipDomainInstance
 *
 * @function remove
 * @memberof Twilio.Trunking.V1.TrunkContext.TerminatingSipDomainContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed TerminatingSipDomainInstance
 */
/* jshint ignore:end */
TerminatingSipDomainContext.prototype.remove = function remove(callback) {
  var deferred = Q.defer();
  var promise = this._version.remove({uri: this._uri, method: 'DELETE'});

  promise = promise.then(function(payload) {
    deferred.resolve(payload);
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Trunking.V1.TrunkContext.TerminatingSipDomainContext#
 *
 * @returns Object
 */
/* jshint ignore:end */
TerminatingSipDomainContext.prototype.toJSON = function toJSON() {
  return this._solution;
};

TerminatingSipDomainContext.prototype[util.inspect.custom] = function
    inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  TerminatingSipDomainList: TerminatingSipDomainList,
  TerminatingSipDomainPage: TerminatingSipDomainPage,
  TerminatingSipDomainInstance: TerminatingSipDomainInstance,
  TerminatingSipDomainContext: TerminatingSipDomainContext
};
