/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../../base/Page');
import Response = require('../../../../http/response');
import V1 = require('../../V1');
import { SerializableClass } from '../../../../interfaces';

/**
 * Initialize the TerminatingSipDomainList
 *
 * @param version - Version of the resource
 * @param trunkSid - The SID of the Trunk to which we should route calls
 */
declare function TerminatingSipDomainList(version: V1, trunkSid: string): TerminatingSipDomainListInstance;

interface TerminatingSipDomainListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): TerminatingSipDomainContext;
  /**
   * create a TerminatingSipDomainInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  create(opts: TerminatingSipDomainListInstanceCreateOptions, callback?: (error: Error | null, item: TerminatingSipDomainInstance) => any): Promise<TerminatingSipDomainInstance>;
  /**
   * Streams TerminatingSipDomainInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Function to process each record
   */
  each(opts?: TerminatingSipDomainListInstanceEachOptions, callback?: (item: TerminatingSipDomainInstance, done: (err?: Error) => void) => void): void;
  /**
   * Constructs a terminating_sip_domain
   *
   * @param sid - The unique string that identifies the resource
   */
  get(sid: string): TerminatingSipDomainContext;
  /**
   * Retrieve a single target page of TerminatingSipDomainInstance records from the
   * API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param targetUrl - API-generated URL for the requested results page
   * @param callback - Callback to handle list of records
   */
  getPage(targetUrl?: string, callback?: (error: Error | null, items: TerminatingSipDomainPage) => any): Promise<TerminatingSipDomainPage>;
  /**
   * Lists TerminatingSipDomainInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  list(opts?: TerminatingSipDomainListInstanceOptions, callback?: (error: Error | null, items: TerminatingSipDomainInstance[]) => any): Promise<TerminatingSipDomainInstance[]>;
  /**
   * Retrieve a single page of TerminatingSipDomainInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  page(opts?: TerminatingSipDomainListInstancePageOptions, callback?: (error: Error | null, items: TerminatingSipDomainPage) => any): Promise<TerminatingSipDomainPage>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to create
 *
 * @property sipDomainSid - The SID of the SIP Domain to associate with the trunk
 */
interface TerminatingSipDomainListInstanceCreateOptions {
  sipDomainSid: string;
}

/**
 * Options to pass to each
 *
 * @property callback -
 *                         Function to process each record. If this and a positional
 *                         callback are passed, this one will be used
 * @property done - Function to be called upon completion of streaming
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         each() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no pageSize is defined but a limit is defined,
 *                         each() will attempt to read the limit with the most efficient
 *                         page size, i.e. min(limit, 1000)
 */
interface TerminatingSipDomainListInstanceEachOptions {
  callback?: (item: TerminatingSipDomainInstance, done: (err?: Error) => void) => void;
  done?: Function;
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to list
 *
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         list() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no page_size is defined but a limit is defined,
 *                         list() will attempt to read the limit with the most
 *                         efficient page size, i.e. min(limit, 1000)
 */
interface TerminatingSipDomainListInstanceOptions {
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to page
 *
 * @property pageNumber - Page Number, this value is simply for client state
 * @property pageSize - Number of records to return, defaults to 50
 * @property pageToken - PageToken provided by the API
 */
interface TerminatingSipDomainListInstancePageOptions {
  pageNumber?: number;
  pageSize?: number;
  pageToken?: string;
}

interface TerminatingSipDomainPayload extends TerminatingSipDomainResource, Page.TwilioResponsePayload {
}

interface TerminatingSipDomainResource {
  account_sid: string;
  api_version: string;
  auth_type: string;
  date_created: Date;
  date_updated: Date;
  domain_name: string;
  friendly_name: string;
  links: string;
  sid: string;
  sip_registration: boolean;
  trunk_sid: string;
  url: string;
  voice_fallback_method: string;
  voice_fallback_url: string;
  voice_method: string;
  voice_status_callback_method: string;
  voice_status_callback_url: string;
  voice_url: string;
}

interface TerminatingSipDomainSolution {
  trunkSid?: string;
}


declare class TerminatingSipDomainContext {
  /**
   * Initialize the TerminatingSipDomainContext
   *
   * @param version - Version of the resource
   * @param trunkSid - The SID of the Trunk with the resource to fetch
   * @param sid - The unique string that identifies the resource
   */
  constructor(version: V1, trunkSid: string, sid: string);

  /**
   * fetch a TerminatingSipDomainInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: TerminatingSipDomainInstance) => any): Promise<TerminatingSipDomainInstance>;
  /**
   * remove a TerminatingSipDomainInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: TerminatingSipDomainInstance) => any): Promise<boolean>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class TerminatingSipDomainInstance extends SerializableClass {
  /**
   * Initialize the TerminatingSipDomainContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param trunkSid - The SID of the Trunk to which we should route calls
   * @param sid - The unique string that identifies the resource
   */
  constructor(version: V1, payload: TerminatingSipDomainPayload, trunkSid: string, sid: string);

  private _proxy: TerminatingSipDomainContext;
  accountSid: string;
  apiVersion: string;
  authType: string;
  dateCreated: Date;
  dateUpdated: Date;
  domainName: string;
  /**
   * fetch a TerminatingSipDomainInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: TerminatingSipDomainInstance) => any): Promise<TerminatingSipDomainInstance>;
  friendlyName: string;
  links: string;
  /**
   * remove a TerminatingSipDomainInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: TerminatingSipDomainInstance) => any): Promise<boolean>;
  sid: string;
  sipRegistration: boolean;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  trunkSid: string;
  url: string;
  voiceFallbackMethod: string;
  voiceFallbackUrl: string;
  voiceMethod: string;
  voiceStatusCallbackMethod: string;
  voiceStatusCallbackUrl: string;
  voiceUrl: string;
}


declare class TerminatingSipDomainPage extends Page<V1, TerminatingSipDomainPayload, TerminatingSipDomainResource, TerminatingSipDomainInstance> {
  /**
   * Initialize the TerminatingSipDomainPage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: TerminatingSipDomainSolution);

  /**
   * Build an instance of TerminatingSipDomainInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: TerminatingSipDomainPayload): TerminatingSipDomainInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { TerminatingSipDomainContext, TerminatingSipDomainInstance, TerminatingSipDomainList, TerminatingSipDomainListInstance, TerminatingSipDomainListInstanceCreateOptions, TerminatingSipDomainListInstanceEachOptions, TerminatingSipDomainListInstanceOptions, TerminatingSipDomainListInstancePageOptions, TerminatingSipDomainPage, TerminatingSipDomainPayload, TerminatingSipDomainResource, TerminatingSipDomainSolution }
