/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../../../base/Page');
import Response = require('../../../../../http/response');
import V1 = require('../../../V1');
import serialize = require('../../../../../base/serialize');
import { SerializableClass } from '../../../../../interfaces';

/**
 * Initialize the WorkflowStatisticsList
 *
 * @param version - Version of the resource
 * @param workspaceSid - The SID of the Workspace that contains the Workflow
 * @param workflowSid - Returns the list of Tasks that are being controlled by the Workflow with the specified SID value
 */
declare function WorkflowStatisticsList(version: V1, workspaceSid: string, workflowSid: string): WorkflowStatisticsListInstance;

/**
 * Options to pass to fetch
 *
 * @property endDate - Only calculate statistics from this date and time and earlier
 * @property minutes - Only calculate statistics since this many minutes in the past
 * @property splitByWaitTime - A comma separated list of values that describes the thresholds to calculate statistics on
 * @property startDate - Only calculate statistics from on or after this date
 * @property taskChannel - Only calculate real-time statistics on this TaskChannel.
 */
interface WorkflowStatisticsInstanceFetchOptions {
  endDate?: Date;
  minutes?: number;
  splitByWaitTime?: string;
  startDate?: Date;
  taskChannel?: string;
}

interface WorkflowStatisticsListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): WorkflowStatisticsContext;
  /**
   * Constructs a workflow_statistics
   */
  get(): WorkflowStatisticsContext;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

interface WorkflowStatisticsPayload extends WorkflowStatisticsResource, Page.TwilioResponsePayload {
}

interface WorkflowStatisticsResource {
  account_sid: string;
  cumulative: object;
  realtime: object;
  url: string;
  workflow_sid: string;
  workspace_sid: string;
}

interface WorkflowStatisticsSolution {
  workflowSid?: string;
  workspaceSid?: string;
}


declare class WorkflowStatisticsContext {
  /**
   * Initialize the WorkflowStatisticsContext
   *
   * @param version - Version of the resource
   * @param workspaceSid - The SID of the Workspace with the Workflow to fetch
   * @param workflowSid - Returns the list of Tasks that are being controlled by the Workflow with the specified SID value
   */
  constructor(version: V1, workspaceSid: string, workflowSid: string);

  /**
   * fetch a WorkflowStatisticsInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  fetch(opts?: WorkflowStatisticsInstanceFetchOptions, callback?: (error: Error | null, items: WorkflowStatisticsInstance) => any): Promise<WorkflowStatisticsInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class WorkflowStatisticsInstance extends SerializableClass {
  /**
   * Initialize the WorkflowStatisticsContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param workspaceSid - The SID of the Workspace that contains the Workflow
   * @param workflowSid - Returns the list of Tasks that are being controlled by the Workflow with the specified SID value
   */
  constructor(version: V1, payload: WorkflowStatisticsPayload, workspaceSid: string, workflowSid: string);

  private _proxy: WorkflowStatisticsContext;
  accountSid: string;
  cumulative: object;
  /**
   * fetch a WorkflowStatisticsInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  fetch(opts?: WorkflowStatisticsInstanceFetchOptions, callback?: (error: Error | null, items: WorkflowStatisticsInstance) => any): Promise<WorkflowStatisticsInstance>;
  realtime: object;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  url: string;
  workflowSid: string;
  workspaceSid: string;
}


declare class WorkflowStatisticsPage extends Page<V1, WorkflowStatisticsPayload, WorkflowStatisticsResource, WorkflowStatisticsInstance> {
  /**
   * Initialize the WorkflowStatisticsPage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: WorkflowStatisticsSolution);

  /**
   * Build an instance of WorkflowStatisticsInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: WorkflowStatisticsPayload): WorkflowStatisticsInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { WorkflowStatisticsContext, WorkflowStatisticsInstance, WorkflowStatisticsInstanceFetchOptions, WorkflowStatisticsList, WorkflowStatisticsListInstance, WorkflowStatisticsPage, WorkflowStatisticsPayload, WorkflowStatisticsResource, WorkflowStatisticsSolution }
