/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../../../base/Page');
import Response = require('../../../../../http/response');
import V1 = require('../../../V1');
import serialize = require('../../../../../base/serialize');
import { SerializableClass } from '../../../../../interfaces';

/**
 * Initialize the WorkersCumulativeStatisticsList
 *
 * @param version - Version of the resource
 * @param workspaceSid - The SID of the Workspace that contains the Workers
 */
declare function WorkersCumulativeStatisticsList(version: V1, workspaceSid: string): WorkersCumulativeStatisticsListInstance;

/**
 * Options to pass to fetch
 *
 * @property endDate - Only calculate statistics from on or before this date
 * @property minutes - Only calculate statistics since this many minutes in the past
 * @property startDate - Only calculate statistics from on or after this date
 * @property taskChannel - Only calculate cumulative statistics on this TaskChannel
 */
interface WorkersCumulativeStatisticsInstanceFetchOptions {
  endDate?: Date;
  minutes?: number;
  startDate?: Date;
  taskChannel?: string;
}

interface WorkersCumulativeStatisticsListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): WorkersCumulativeStatisticsContext;
  /**
   * Constructs a workers_cumulative_statistics
   */
  get(): WorkersCumulativeStatisticsContext;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

interface WorkersCumulativeStatisticsPayload extends WorkersCumulativeStatisticsResource, Page.TwilioResponsePayload {
}

interface WorkersCumulativeStatisticsResource {
  account_sid: string;
  activity_durations: object[];
  end_time: Date;
  reservations_accepted: number;
  reservations_canceled: number;
  reservations_created: number;
  reservations_rejected: number;
  reservations_rescinded: number;
  reservations_timed_out: number;
  start_time: Date;
  url: string;
  workspace_sid: string;
}

interface WorkersCumulativeStatisticsSolution {
  workspaceSid?: string;
}


declare class WorkersCumulativeStatisticsContext {
  /**
   * Initialize the WorkersCumulativeStatisticsContext
   *
   * @param version - Version of the resource
   * @param workspaceSid - The SID of the Workspace with the resource to fetch
   */
  constructor(version: V1, workspaceSid: string);

  /**
   * fetch a WorkersCumulativeStatisticsInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  fetch(opts?: WorkersCumulativeStatisticsInstanceFetchOptions, callback?: (error: Error | null, items: WorkersCumulativeStatisticsInstance) => any): Promise<WorkersCumulativeStatisticsInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class WorkersCumulativeStatisticsInstance extends SerializableClass {
  /**
   * Initialize the WorkersCumulativeStatisticsContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param workspaceSid - The SID of the Workspace that contains the Workers
   */
  constructor(version: V1, payload: WorkersCumulativeStatisticsPayload, workspaceSid: string);

  private _proxy: WorkersCumulativeStatisticsContext;
  accountSid: string;
  activityDurations: object[];
  endTime: Date;
  /**
   * fetch a WorkersCumulativeStatisticsInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  fetch(opts?: WorkersCumulativeStatisticsInstanceFetchOptions, callback?: (error: Error | null, items: WorkersCumulativeStatisticsInstance) => any): Promise<WorkersCumulativeStatisticsInstance>;
  reservationsAccepted: number;
  reservationsCanceled: number;
  reservationsCreated: number;
  reservationsRejected: number;
  reservationsRescinded: number;
  reservationsTimedOut: number;
  startTime: Date;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  url: string;
  workspaceSid: string;
}


declare class WorkersCumulativeStatisticsPage extends Page<V1, WorkersCumulativeStatisticsPayload, WorkersCumulativeStatisticsResource, WorkersCumulativeStatisticsInstance> {
  /**
   * Initialize the WorkersCumulativeStatisticsPage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: WorkersCumulativeStatisticsSolution);

  /**
   * Build an instance of WorkersCumulativeStatisticsInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: WorkersCumulativeStatisticsPayload): WorkersCumulativeStatisticsInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { WorkersCumulativeStatisticsContext, WorkersCumulativeStatisticsInstance, WorkersCumulativeStatisticsInstanceFetchOptions, WorkersCumulativeStatisticsList, WorkersCumulativeStatisticsListInstance, WorkersCumulativeStatisticsPage, WorkersCumulativeStatisticsPayload, WorkersCumulativeStatisticsResource, WorkersCumulativeStatisticsSolution }
