/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../../base/Page');
import Response = require('../../../../http/response');
import V1 = require('../../V1');
import serialize = require('../../../../base/serialize');
import { SerializableClass } from '../../../../interfaces';

/**
 * Initialize the EventList
 *
 * @param version - Version of the resource
 * @param workspaceSid - The SID of the Workspace that contains the Event
 */
declare function EventList(version: V1, workspaceSid: string): EventListInstance;

interface EventListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): EventContext;
  /**
   * Streams EventInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Function to process each record
   */
  each(opts?: EventListInstanceEachOptions, callback?: (item: EventInstance, done: (err?: Error) => void) => void): void;
  /**
   * Constructs a event
   *
   * @param sid - The SID of the resource to fetch
   */
  get(sid: string): EventContext;
  /**
   * Retrieve a single target page of EventInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param targetUrl - API-generated URL for the requested results page
   * @param callback - Callback to handle list of records
   */
  getPage(targetUrl?: string, callback?: (error: Error | null, items: EventPage) => any): Promise<EventPage>;
  /**
   * Lists EventInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  list(opts?: EventListInstanceOptions, callback?: (error: Error | null, items: EventInstance[]) => any): Promise<EventInstance[]>;
  /**
   * Retrieve a single page of EventInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  page(opts?: EventListInstancePageOptions, callback?: (error: Error | null, items: EventPage) => any): Promise<EventPage>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to each
 *
 * @property callback -
 *                         Function to process each record. If this and a positional
 *                         callback are passed, this one will be used
 * @property done - Function to be called upon completion of streaming
 * @property endDate - Only include usage that occurred on or before this date
 * @property eventType - The type of Events to read
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         each() guarantees never to return more than limit.
 *                         Default is no limit
 * @property minutes - The period of events to read in minutes
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no pageSize is defined but a limit is defined,
 *                         each() will attempt to read the limit with the most efficient
 *                         page size, i.e. min(limit, 1000)
 * @property reservationSid - The SID of the Reservation with the Events to read
 * @property sid - The unique string that identifies the resource
 * @property startDate - Only include Events from on or after this date
 * @property taskChannel - The TaskChannel with the Events to read
 * @property taskQueueSid - The SID of the TaskQueue with the Events to read
 * @property taskSid - The SID of the Task with the Events to read
 * @property workerSid - The SID of the Worker with the Events to read
 * @property workflowSid - The SID of the Worker with the Events to read
 */
interface EventListInstanceEachOptions {
  callback?: (item: EventInstance, done: (err?: Error) => void) => void;
  done?: Function;
  endDate?: Date;
  eventType?: string;
  limit?: number;
  minutes?: number;
  pageSize?: number;
  reservationSid?: string;
  sid?: string;
  startDate?: Date;
  taskChannel?: string;
  taskQueueSid?: string;
  taskSid?: string;
  workerSid?: string;
  workflowSid?: string;
}

/**
 * Options to pass to list
 *
 * @property endDate - Only include usage that occurred on or before this date
 * @property eventType - The type of Events to read
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         list() guarantees never to return more than limit.
 *                         Default is no limit
 * @property minutes - The period of events to read in minutes
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no page_size is defined but a limit is defined,
 *                         list() will attempt to read the limit with the most
 *                         efficient page size, i.e. min(limit, 1000)
 * @property reservationSid - The SID of the Reservation with the Events to read
 * @property sid - The unique string that identifies the resource
 * @property startDate - Only include Events from on or after this date
 * @property taskChannel - The TaskChannel with the Events to read
 * @property taskQueueSid - The SID of the TaskQueue with the Events to read
 * @property taskSid - The SID of the Task with the Events to read
 * @property workerSid - The SID of the Worker with the Events to read
 * @property workflowSid - The SID of the Worker with the Events to read
 */
interface EventListInstanceOptions {
  endDate?: Date;
  eventType?: string;
  limit?: number;
  minutes?: number;
  pageSize?: number;
  reservationSid?: string;
  sid?: string;
  startDate?: Date;
  taskChannel?: string;
  taskQueueSid?: string;
  taskSid?: string;
  workerSid?: string;
  workflowSid?: string;
}

/**
 * Options to pass to page
 *
 * @property endDate - Only include usage that occurred on or before this date
 * @property eventType - The type of Events to read
 * @property minutes - The period of events to read in minutes
 * @property pageNumber - Page Number, this value is simply for client state
 * @property pageSize - Number of records to return, defaults to 50
 * @property pageToken - PageToken provided by the API
 * @property reservationSid - The SID of the Reservation with the Events to read
 * @property sid - The unique string that identifies the resource
 * @property startDate - Only include Events from on or after this date
 * @property taskChannel - The TaskChannel with the Events to read
 * @property taskQueueSid - The SID of the TaskQueue with the Events to read
 * @property taskSid - The SID of the Task with the Events to read
 * @property workerSid - The SID of the Worker with the Events to read
 * @property workflowSid - The SID of the Worker with the Events to read
 */
interface EventListInstancePageOptions {
  endDate?: Date;
  eventType?: string;
  minutes?: number;
  pageNumber?: number;
  pageSize?: number;
  pageToken?: string;
  reservationSid?: string;
  sid?: string;
  startDate?: Date;
  taskChannel?: string;
  taskQueueSid?: string;
  taskSid?: string;
  workerSid?: string;
  workflowSid?: string;
}

interface EventPayload extends EventResource, Page.TwilioResponsePayload {
}

interface EventResource {
  account_sid: string;
  actor_sid: string;
  actor_type: string;
  actor_url: string;
  description: string;
  event_data: object;
  event_date: Date;
  event_date_ms: number;
  event_type: string;
  resource_sid: string;
  resource_type: string;
  resource_url: string;
  sid: string;
  source: string;
  source_ip_address: string;
  url: string;
  workspace_sid: string;
}

interface EventSolution {
  workspaceSid?: string;
}


declare class EventContext {
  /**
   * Initialize the EventContext
   *
   * @param version - Version of the resource
   * @param workspaceSid - The SID of the Workspace with the Event to fetch
   * @param sid - The SID of the resource to fetch
   */
  constructor(version: V1, workspaceSid: string, sid: string);

  /**
   * fetch a EventInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: EventInstance) => any): Promise<EventInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class EventInstance extends SerializableClass {
  /**
   * Initialize the EventContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param workspaceSid - The SID of the Workspace that contains the Event
   * @param sid - The SID of the resource to fetch
   */
  constructor(version: V1, payload: EventPayload, workspaceSid: string, sid: string);

  private _proxy: EventContext;
  accountSid: string;
  actorSid: string;
  actorType: string;
  actorUrl: string;
  description: string;
  eventData: object;
  eventDate: Date;
  eventDateMs: number;
  eventType: string;
  /**
   * fetch a EventInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: EventInstance) => any): Promise<EventInstance>;
  resourceSid: string;
  resourceType: string;
  resourceUrl: string;
  sid: string;
  source: string;
  sourceIpAddress: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  url: string;
  workspaceSid: string;
}


declare class EventPage extends Page<V1, EventPayload, EventResource, EventInstance> {
  /**
   * Initialize the EventPage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: EventSolution);

  /**
   * Build an instance of EventInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: EventPayload): EventInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { EventContext, EventInstance, EventList, EventListInstance, EventListInstanceEachOptions, EventListInstanceOptions, EventListInstancePageOptions, EventPage, EventPayload, EventResource, EventSolution }
