/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../../base/Page');
import Response = require('../../../../http/response');
import V2 = require('../../V2');
import { SerializableClass } from '../../../../interfaces';

type FlowRevisionStatus = 'draft'|'published';

/**
 * Initialize the FlowRevisionList
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @param version - Version of the resource
 * @param sid - The unique string that identifies the resource
 */
declare function FlowRevisionList(version: V2, sid: string): FlowRevisionListInstance;

interface FlowRevisionListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): FlowRevisionContext;
  /**
   * Streams FlowRevisionInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Function to process each record
   */
  each(opts?: FlowRevisionListInstanceEachOptions, callback?: (item: FlowRevisionInstance, done: (err?: Error) => void) => void): void;
  /**
   * Constructs a flow_revision
   *
   * @param revision - Specific Revision number or can be `LatestPublished` and `LatestRevision`
   */
  get(revision: string): FlowRevisionContext;
  /**
   * Retrieve a single target page of FlowRevisionInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param targetUrl - API-generated URL for the requested results page
   * @param callback - Callback to handle list of records
   */
  getPage(targetUrl?: string, callback?: (error: Error | null, items: FlowRevisionPage) => any): Promise<FlowRevisionPage>;
  /**
   * Lists FlowRevisionInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  list(opts?: FlowRevisionListInstanceOptions, callback?: (error: Error | null, items: FlowRevisionInstance[]) => any): Promise<FlowRevisionInstance[]>;
  /**
   * Retrieve a single page of FlowRevisionInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  page(opts?: FlowRevisionListInstancePageOptions, callback?: (error: Error | null, items: FlowRevisionPage) => any): Promise<FlowRevisionPage>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to each
 *
 * @property callback -
 *                         Function to process each record. If this and a positional
 *                         callback are passed, this one will be used
 * @property done - Function to be called upon completion of streaming
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         each() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no pageSize is defined but a limit is defined,
 *                         each() will attempt to read the limit with the most efficient
 *                         page size, i.e. min(limit, 1000)
 */
interface FlowRevisionListInstanceEachOptions {
  callback?: (item: FlowRevisionInstance, done: (err?: Error) => void) => void;
  done?: Function;
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to list
 *
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         list() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no page_size is defined but a limit is defined,
 *                         list() will attempt to read the limit with the most
 *                         efficient page size, i.e. min(limit, 1000)
 */
interface FlowRevisionListInstanceOptions {
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to page
 *
 * @property pageNumber - Page Number, this value is simply for client state
 * @property pageSize - Number of records to return, defaults to 50
 * @property pageToken - PageToken provided by the API
 */
interface FlowRevisionListInstancePageOptions {
  pageNumber?: number;
  pageSize?: number;
  pageToken?: string;
}

interface FlowRevisionPayload extends FlowRevisionResource, Page.TwilioResponsePayload {
}

interface FlowRevisionResource {
  account_sid: string;
  commit_message: string;
  date_created: Date;
  date_updated: Date;
  definition: object;
  errors: object[];
  friendly_name: string;
  revision: number;
  sid: string;
  status: FlowRevisionStatus;
  url: string;
  valid: boolean;
}

interface FlowRevisionSolution {
  sid?: string;
}


declare class FlowRevisionContext {
  /**
   * Initialize the FlowRevisionContext
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param sid - The SID that identifies the resource to fetch
   * @param revision - Specific Revision number or can be `LatestPublished` and `LatestRevision`
   */
  constructor(version: V2, sid: string, revision: string);

  /**
   * fetch a FlowRevisionInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: FlowRevisionInstance) => any): Promise<FlowRevisionInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class FlowRevisionInstance extends SerializableClass {
  /**
   * Initialize the FlowRevisionContext
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param sid - The unique string that identifies the resource
   * @param revision - Specific Revision number or can be `LatestPublished` and `LatestRevision`
   */
  constructor(version: V2, payload: FlowRevisionPayload, sid: string, revision: string);

  private _proxy: FlowRevisionContext;
  accountSid: string;
  commitMessage: string;
  dateCreated: Date;
  dateUpdated: Date;
  definition: object;
  errors: object[];
  /**
   * fetch a FlowRevisionInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: FlowRevisionInstance) => any): Promise<FlowRevisionInstance>;
  friendlyName: string;
  revision: number;
  sid: string;
  status: FlowRevisionStatus;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  url: string;
  valid: boolean;
}


declare class FlowRevisionPage extends Page<V2, FlowRevisionPayload, FlowRevisionResource, FlowRevisionInstance> {
  /**
   * Initialize the FlowRevisionPage
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V2, response: Response<string>, solution: FlowRevisionSolution);

  /**
   * Build an instance of FlowRevisionInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: FlowRevisionPayload): FlowRevisionInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { FlowRevisionContext, FlowRevisionInstance, FlowRevisionList, FlowRevisionListInstance, FlowRevisionListInstanceEachOptions, FlowRevisionListInstanceOptions, FlowRevisionListInstancePageOptions, FlowRevisionPage, FlowRevisionPayload, FlowRevisionResource, FlowRevisionSolution, FlowRevisionStatus }
