/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../../../base/Page');
import Response = require('../../../../../http/response');
import V2 = require('../../../V2');
import { SerializableClass } from '../../../../../interfaces';

/**
 * Initialize the ExecutionContextList
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @param version - Version of the resource
 * @param flowSid - The flow_sid
 * @param executionSid - The execution_sid
 */
declare function ExecutionContextList(version: V2, flowSid: string, executionSid: string): ExecutionContextListInstance;

interface ExecutionContextListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): ExecutionContextContext;
  /**
   * Constructs a execution_context
   */
  get(): ExecutionContextContext;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

interface ExecutionContextPayload extends ExecutionContextResource, Page.TwilioResponsePayload {
}

interface ExecutionContextResource {
  account_sid: string;
  context: object;
  execution_sid: string;
  flow_sid: string;
  url: string;
}

interface ExecutionContextSolution {
  executionSid?: string;
  flowSid?: string;
}


declare class ExecutionContextContext {
  /**
   * Initialize the ExecutionContextContext
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param flowSid - The flow_sid
   * @param executionSid - The execution_sid
   */
  constructor(version: V2, flowSid: string, executionSid: string);

  /**
   * fetch a ExecutionContextInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: ExecutionContextInstance) => any): Promise<ExecutionContextInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class ExecutionContextInstance extends SerializableClass {
  /**
   * Initialize the ExecutionContextContext
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param flowSid - The flow_sid
   * @param executionSid - The execution_sid
   */
  constructor(version: V2, payload: ExecutionContextPayload, flowSid: string, executionSid: string);

  private _proxy: ExecutionContextContext;
  accountSid: string;
  context: object;
  executionSid: string;
  /**
   * fetch a ExecutionContextInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: ExecutionContextInstance) => any): Promise<ExecutionContextInstance>;
  flowSid: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  url: string;
}


declare class ExecutionContextPage extends Page<V2, ExecutionContextPayload, ExecutionContextResource, ExecutionContextInstance> {
  /**
   * Initialize the ExecutionContextPage
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V2, response: Response<string>, solution: ExecutionContextSolution);

  /**
   * Build an instance of ExecutionContextInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: ExecutionContextPayload): ExecutionContextInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { ExecutionContextContext, ExecutionContextInstance, ExecutionContextList, ExecutionContextListInstance, ExecutionContextPage, ExecutionContextPayload, ExecutionContextResource, ExecutionContextSolution }
