/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../../base/Page');
import Response = require('../../../../http/response');
import V1 = require('../../V1');
import { AssetVersionList } from './asset/assetVersion';
import { AssetVersionListInstance } from './asset/assetVersion';
import { SerializableClass } from '../../../../interfaces';

/**
 * Initialize the AssetList
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @param version - Version of the resource
 * @param serviceSid - The SID of the Service that the Asset resource is associated with
 */
declare function AssetList(version: V1, serviceSid: string): AssetListInstance;

/**
 * Options to pass to update
 *
 * @property friendlyName - A string to describe the Asset resource
 */
interface AssetInstanceUpdateOptions {
  friendlyName: string;
}

interface AssetListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): AssetContext;
  /**
   * create a AssetInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  create(opts: AssetListInstanceCreateOptions, callback?: (error: Error | null, item: AssetInstance) => any): Promise<AssetInstance>;
  /**
   * Streams AssetInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Function to process each record
   */
  each(opts?: AssetListInstanceEachOptions, callback?: (item: AssetInstance, done: (err?: Error) => void) => void): void;
  /**
   * Constructs a asset
   *
   * @param sid - The SID that identifies the Asset resource to fetch
   */
  get(sid: string): AssetContext;
  /**
   * Retrieve a single target page of AssetInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param targetUrl - API-generated URL for the requested results page
   * @param callback - Callback to handle list of records
   */
  getPage(targetUrl?: string, callback?: (error: Error | null, items: AssetPage) => any): Promise<AssetPage>;
  /**
   * Lists AssetInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  list(opts?: AssetListInstanceOptions, callback?: (error: Error | null, items: AssetInstance[]) => any): Promise<AssetInstance[]>;
  /**
   * Retrieve a single page of AssetInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  page(opts?: AssetListInstancePageOptions, callback?: (error: Error | null, items: AssetPage) => any): Promise<AssetPage>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to create
 *
 * @property friendlyName - A string to describe the Asset resource
 */
interface AssetListInstanceCreateOptions {
  friendlyName: string;
}

/**
 * Options to pass to each
 *
 * @property callback -
 *                         Function to process each record. If this and a positional
 *                         callback are passed, this one will be used
 * @property done - Function to be called upon completion of streaming
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         each() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no pageSize is defined but a limit is defined,
 *                         each() will attempt to read the limit with the most efficient
 *                         page size, i.e. min(limit, 1000)
 */
interface AssetListInstanceEachOptions {
  callback?: (item: AssetInstance, done: (err?: Error) => void) => void;
  done?: Function;
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to list
 *
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         list() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no page_size is defined but a limit is defined,
 *                         list() will attempt to read the limit with the most
 *                         efficient page size, i.e. min(limit, 1000)
 */
interface AssetListInstanceOptions {
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to page
 *
 * @property pageNumber - Page Number, this value is simply for client state
 * @property pageSize - Number of records to return, defaults to 50
 * @property pageToken - PageToken provided by the API
 */
interface AssetListInstancePageOptions {
  pageNumber?: number;
  pageSize?: number;
  pageToken?: string;
}

interface AssetPayload extends AssetResource, Page.TwilioResponsePayload {
}

interface AssetResource {
  account_sid: string;
  date_created: Date;
  date_updated: Date;
  friendly_name: string;
  links: string;
  service_sid: string;
  sid: string;
  url: string;
}

interface AssetSolution {
  serviceSid?: string;
}


declare class AssetContext {
  /**
   * Initialize the AssetContext
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param serviceSid - The SID of the Service to fetch the Asset resource from
   * @param sid - The SID that identifies the Asset resource to fetch
   */
  constructor(version: V1, serviceSid: string, sid: string);

  assetVersions: AssetVersionListInstance;
  /**
   * fetch a AssetInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: AssetInstance) => any): Promise<AssetInstance>;
  /**
   * remove a AssetInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: AssetInstance) => any): Promise<boolean>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a AssetInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts: AssetInstanceUpdateOptions, callback?: (error: Error | null, items: AssetInstance) => any): Promise<AssetInstance>;
}


declare class AssetInstance extends SerializableClass {
  /**
   * Initialize the AssetContext
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param serviceSid - The SID of the Service that the Asset resource is associated with
   * @param sid - The SID that identifies the Asset resource to fetch
   */
  constructor(version: V1, payload: AssetPayload, serviceSid: string, sid: string);

  private _proxy: AssetContext;
  accountSid: string;
  /**
   * Access the assetVersions
   */
  assetVersions(): AssetVersionListInstance;
  dateCreated: Date;
  dateUpdated: Date;
  /**
   * fetch a AssetInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: AssetInstance) => any): Promise<AssetInstance>;
  friendlyName: string;
  links: string;
  /**
   * remove a AssetInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: AssetInstance) => any): Promise<boolean>;
  serviceSid: string;
  sid: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a AssetInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts: AssetInstanceUpdateOptions, callback?: (error: Error | null, items: AssetInstance) => any): Promise<AssetInstance>;
  url: string;
}


declare class AssetPage extends Page<V1, AssetPayload, AssetResource, AssetInstance> {
  /**
   * Initialize the AssetPage
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: AssetSolution);

  /**
   * Build an instance of AssetInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: AssetPayload): AssetInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { AssetContext, AssetInstance, AssetInstanceUpdateOptions, AssetList, AssetListInstance, AssetListInstanceCreateOptions, AssetListInstanceEachOptions, AssetListInstanceOptions, AssetListInstancePageOptions, AssetPage, AssetPayload, AssetResource, AssetSolution }
