'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var Page = require('../../../../../../base/Page');  /* jshint ignore:line */
var deserialize = require(
    '../../../../../../base/deserialize');  /* jshint ignore:line */
var serialize = require(
    '../../../../../../base/serialize');  /* jshint ignore:line */
var values = require('../../../../../../base/values');  /* jshint ignore:line */

var MessageInteractionList;
var MessageInteractionPage;
var MessageInteractionInstance;
var MessageInteractionContext;

/* jshint ignore:start */
/**
 * Initialize the MessageInteractionList
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Proxy.V1.ServiceContext.SessionContext.ParticipantContext.MessageInteractionList
 *
 * @param {Twilio.Proxy.V1} version - Version of the resource
 * @param {string} serviceSid - The SID of the resource's parent Service
 * @param {string} sessionSid - The SID of the resource's parent Session
 * @param {string} participantSid - The SID of the Participant resource
 */
/* jshint ignore:end */
MessageInteractionList = function MessageInteractionList(version, serviceSid,
                                                          sessionSid,
                                                          participantSid) {
  /* jshint ignore:start */
  /**
   * @function messageInteractions
   * @memberof Twilio.Proxy.V1.ServiceContext.SessionContext.ParticipantContext#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Proxy.V1.ServiceContext.SessionContext.ParticipantContext.MessageInteractionContext}
   */
  /* jshint ignore:end */
  function MessageInteractionListInstance(sid) {
    return MessageInteractionListInstance.get(sid);
  }

  MessageInteractionListInstance._version = version;
  // Path Solution
  MessageInteractionListInstance._solution = {
    serviceSid: serviceSid,
    sessionSid: sessionSid,
    participantSid: participantSid
  };
  MessageInteractionListInstance._uri = `/Services/${serviceSid}/Sessions/${sessionSid}/Participants/${participantSid}/MessageInteractions`;
  /* jshint ignore:start */
  /**
   * create a MessageInteractionInstance
   *
   * @function create
   * @memberof Twilio.Proxy.V1.ServiceContext.SessionContext.ParticipantContext.MessageInteractionList#
   *
   * @param {object} [opts] - Options for request
   * @param {string} [opts.body] - Message body
   * @param {string|list} [opts.mediaUrl] - Reserved
   * @param {function} [callback] - Callback to handle processed record
   *
   * @returns {Promise} Resolves to processed MessageInteractionInstance
   */
  /* jshint ignore:end */
  MessageInteractionListInstance.create = function create(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};

    var deferred = Q.defer();
    var data = values.of({
      'Body': _.get(opts, 'body'),
      'MediaUrl': serialize.map(_.get(opts, 'mediaUrl'), function(e) { return e; })
    });

    var promise = this._version.create({uri: this._uri, method: 'POST', data: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new MessageInteractionInstance(
        this._version,
        payload,
        this._solution.serviceSid,
        this._solution.sessionSid,
        this._solution.participantSid,
        this._solution.sid
      ));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Streams MessageInteractionInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function each
   * @memberof Twilio.Proxy.V1.ServiceContext.SessionContext.ParticipantContext.MessageInteractionList#
   *
   * @param {object} [opts] - Options for request
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         each() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no pageSize is defined but a limit is defined,
   *         each() will attempt to read the limit with the most efficient
   *         page size, i.e. min(limit, 1000)
   * @param {Function} [opts.callback] -
   *         Function to process each record. If this and a positional
   *         callback are passed, this one will be used
   * @param {Function} [opts.done] -
   *          Function to be called upon completion of streaming
   * @param {Function} [callback] - Function to process each record
   */
  /* jshint ignore:end */
  MessageInteractionListInstance.each = function each(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    if (opts.callback) {
      callback = opts.callback;
    }
    if (_.isUndefined(callback)) {
      throw new Error('Callback function must be provided');
    }

    var done = false;
    var currentPage = 1;
    var currentResource = 0;
    var limits = this._version.readLimits({
      limit: opts.limit,
      pageSize: opts.pageSize
    });

    function onComplete(error) {
      done = true;
      if (_.isFunction(opts.done)) {
        opts.done(error);
      }
    }

    function fetchNextPage(fn) {
      var promise = fn();
      if (_.isUndefined(promise)) {
        onComplete();
        return;
      }

      promise.then(function(page) {
        _.each(page.instances, function(instance) {
          if (done || (!_.isUndefined(opts.limit) && currentResource >= opts.limit)) {
            done = true;
            return false;
          }

          currentResource++;
          callback(instance, onComplete);
        });

        if ((limits.pageLimit && limits.pageLimit <= currentPage)) {
          onComplete();
        } else if (!done) {
          currentPage++;
          fetchNextPage(_.bind(page.nextPage, page));
        }
      });

      promise.catch(onComplete);
    }

    fetchNextPage(_.bind(this.page, this, _.merge(opts, limits)));
  };

  /* jshint ignore:start */
  /**
   * Lists MessageInteractionInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function list
   * @memberof Twilio.Proxy.V1.ServiceContext.SessionContext.ParticipantContext.MessageInteractionList#
   *
   * @param {object} [opts] - Options for request
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         list() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no page_size is defined but a limit is defined,
   *         list() will attempt to read the limit with the most
   *         efficient page size, i.e. min(limit, 1000)
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  MessageInteractionListInstance.list = function list(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    var deferred = Q.defer();
    var allResources = [];
    opts.callback = function(resource, done) {
      allResources.push(resource);

      if (!_.isUndefined(opts.limit) && allResources.length === opts.limit) {
        done();
      }
    };

    opts.done = function(error) {
      if (_.isUndefined(error)) {
        deferred.resolve(allResources);
      } else {
        deferred.reject(error);
      }
    };

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    this.each(opts);
    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single page of MessageInteractionInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function page
   * @memberof Twilio.Proxy.V1.ServiceContext.SessionContext.ParticipantContext.MessageInteractionList#
   *
   * @param {object} [opts] - Options for request
   * @param {string} [opts.pageToken] - PageToken provided by the API
   * @param {number} [opts.pageNumber] -
   *          Page Number, this value is simply for client state
   * @param {number} [opts.pageSize] - Number of records to return, defaults to 50
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  MessageInteractionListInstance.page = function page(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};

    var deferred = Q.defer();
    var data = values.of({
      'PageToken': opts.pageToken,
      'Page': opts.pageNumber,
      'PageSize': opts.pageSize
    });

    var promise = this._version.page({uri: this._uri, method: 'GET', params: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new MessageInteractionPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single target page of MessageInteractionInstance records from the
   * API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function getPage
   * @memberof Twilio.Proxy.V1.ServiceContext.SessionContext.ParticipantContext.MessageInteractionList#
   *
   * @param {string} [targetUrl] - API-generated URL for the requested results page
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  MessageInteractionListInstance.getPage = function getPage(targetUrl, callback) {
    var deferred = Q.defer();

    var promise = this._version._domain.twilio.request({method: 'GET', uri: targetUrl});

    promise = promise.then(function(payload) {
      deferred.resolve(new MessageInteractionPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Constructs a message_interaction
   *
   * @function get
   * @memberof Twilio.Proxy.V1.ServiceContext.SessionContext.ParticipantContext.MessageInteractionList#
   *
   * @param {string} sid - The unique string that identifies the resource
   *
   * @returns {Twilio.Proxy.V1.ServiceContext.SessionContext.ParticipantContext.MessageInteractionContext}
   */
  /* jshint ignore:end */
  MessageInteractionListInstance.get = function get(sid) {
    return new MessageInteractionContext(
      this._version,
      this._solution.serviceSid,
      this._solution.sessionSid,
      this._solution.participantSid,
      sid
    );
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Proxy.V1.ServiceContext.SessionContext.ParticipantContext.MessageInteractionList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  MessageInteractionListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  MessageInteractionListInstance[util.inspect.custom] = function inspect(depth,
      options) {
    return util.inspect(this.toJSON(), options);
  };

  return MessageInteractionListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the MessageInteractionPage
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Proxy.V1.ServiceContext.SessionContext.ParticipantContext.MessageInteractionPage
 *
 * @param {V1} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {MessageInteractionSolution} solution - Path solution
 *
 * @returns MessageInteractionPage
 */
/* jshint ignore:end */
MessageInteractionPage = function MessageInteractionPage(version, response,
                                                          solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(MessageInteractionPage.prototype, Page.prototype);
MessageInteractionPage.prototype.constructor = MessageInteractionPage;

/* jshint ignore:start */
/**
 * Build an instance of MessageInteractionInstance
 *
 * @function getInstance
 * @memberof Twilio.Proxy.V1.ServiceContext.SessionContext.ParticipantContext.MessageInteractionPage#
 *
 * @param {MessageInteractionPayload} payload - Payload response from the API
 *
 * @returns MessageInteractionInstance
 */
/* jshint ignore:end */
MessageInteractionPage.prototype.getInstance = function getInstance(payload) {
  return new MessageInteractionInstance(
    this._version,
    payload,
    this._solution.serviceSid,
    this._solution.sessionSid,
    this._solution.participantSid
  );
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Proxy.V1.ServiceContext.SessionContext.ParticipantContext.MessageInteractionPage#
 *
 * @returns Object
 */
/* jshint ignore:end */
MessageInteractionPage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

MessageInteractionPage.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the MessageInteractionContext
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Proxy.V1.ServiceContext.SessionContext.ParticipantContext.MessageInteractionInstance
 *
 * @property {string} sid - The unique string that identifies the resource
 * @property {string} sessionSid - The SID of the resource's parent Session
 * @property {string} serviceSid - The SID of the resource's parent Service
 * @property {string} accountSid - The SID of the Account that created the resource
 * @property {string} data -
 *          A JSON string that includes the message body sent to the participant
 * @property {message_interaction.type} type - The Type of Message Interaction
 * @property {string} participantSid - The SID of the Participant resource
 * @property {string} inboundParticipantSid - Always empty for Message Interactions
 * @property {string} inboundResourceSid - Always empty for Message Interactions
 * @property {message_interaction.resource_status} inboundResourceStatus -
 *          Always empty for Message Interactions
 * @property {string} inboundResourceType - Always empty for Message Interactions
 * @property {string} inboundResourceUrl - Always empty for Message Interactions
 * @property {string} outboundParticipantSid -
 *          The SID of the outbound Participant resource
 * @property {string} outboundResourceSid -
 *          The SID of the outbound Message resource
 * @property {message_interaction.resource_status} outboundResourceStatus -
 *          The outbound resource status
 * @property {string} outboundResourceType - The outbound resource type
 * @property {string} outboundResourceUrl - The URL of the Twilio message resource
 * @property {Date} dateCreated -
 *          The ISO 8601 date and time in GMT when the resource was created
 * @property {Date} dateUpdated -
 *          The ISO 8601 date and time in GMT when the resource was last updated
 * @property {string} url - The absolute URL of the MessageInteraction resource
 *
 * @param {V1} version - Version of the resource
 * @param {MessageInteractionPayload} payload - The instance payload
 * @param {sid} serviceSid - The SID of the resource's parent Service
 * @param {sid} sessionSid - The SID of the resource's parent Session
 * @param {sid} participantSid - The SID of the Participant resource
 * @param {sid} sid - The unique string that identifies the resource
 */
/* jshint ignore:end */
MessageInteractionInstance = function MessageInteractionInstance(version,
    payload, serviceSid, sessionSid, participantSid, sid) {
  this._version = version;

  // Marshaled Properties
  this.sid = payload.sid; // jshint ignore:line
  this.sessionSid = payload.session_sid; // jshint ignore:line
  this.serviceSid = payload.service_sid; // jshint ignore:line
  this.accountSid = payload.account_sid; // jshint ignore:line
  this.data = payload.data; // jshint ignore:line
  this.type = payload.type; // jshint ignore:line
  this.participantSid = payload.participant_sid; // jshint ignore:line
  this.inboundParticipantSid = payload.inbound_participant_sid; // jshint ignore:line
  this.inboundResourceSid = payload.inbound_resource_sid; // jshint ignore:line
  this.inboundResourceStatus = payload.inbound_resource_status; // jshint ignore:line
  this.inboundResourceType = payload.inbound_resource_type; // jshint ignore:line
  this.inboundResourceUrl = payload.inbound_resource_url; // jshint ignore:line
  this.outboundParticipantSid = payload.outbound_participant_sid; // jshint ignore:line
  this.outboundResourceSid = payload.outbound_resource_sid; // jshint ignore:line
  this.outboundResourceStatus = payload.outbound_resource_status; // jshint ignore:line
  this.outboundResourceType = payload.outbound_resource_type; // jshint ignore:line
  this.outboundResourceUrl = payload.outbound_resource_url; // jshint ignore:line
  this.dateCreated = deserialize.iso8601DateTime(payload.date_created); // jshint ignore:line
  this.dateUpdated = deserialize.iso8601DateTime(payload.date_updated); // jshint ignore:line
  this.url = payload.url; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {
    serviceSid: serviceSid,
    sessionSid: sessionSid,
    participantSid: participantSid,
    sid: sid || this.sid,
  };
};

Object.defineProperty(MessageInteractionInstance.prototype,
  '_proxy', {
    get: function() {
      if (!this._context) {
        this._context = new MessageInteractionContext(
          this._version,
          this._solution.serviceSid,
          this._solution.sessionSid,
          this._solution.participantSid,
          this._solution.sid
        );
      }

      return this._context;
    }
});

/* jshint ignore:start */
/**
 * fetch a MessageInteractionInstance
 *
 * @function fetch
 * @memberof Twilio.Proxy.V1.ServiceContext.SessionContext.ParticipantContext.MessageInteractionInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed MessageInteractionInstance
 */
/* jshint ignore:end */
MessageInteractionInstance.prototype.fetch = function fetch(callback) {
  return this._proxy.fetch(callback);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Proxy.V1.ServiceContext.SessionContext.ParticipantContext.MessageInteractionInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
MessageInteractionInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

MessageInteractionInstance.prototype[util.inspect.custom] = function
    inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the MessageInteractionContext
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Proxy.V1.ServiceContext.SessionContext.ParticipantContext.MessageInteractionContext
 *
 * @param {V1} version - Version of the resource
 * @param {sid} serviceSid - The SID of the Service to fetch the resource from
 * @param {sid} sessionSid - The SID of the parent Session
 * @param {sid} participantSid - The SID of the Participant resource
 * @param {sid} sid - The unique string that identifies the resource
 */
/* jshint ignore:end */
MessageInteractionContext = function MessageInteractionContext(version,
    serviceSid, sessionSid, participantSid, sid) {
  this._version = version;

  // Path Solution
  this._solution = {
    serviceSid: serviceSid,
    sessionSid: sessionSid,
    participantSid: participantSid,
    sid: sid,
  };
  this._uri = `/Services/${serviceSid}/Sessions/${sessionSid}/Participants/${participantSid}/MessageInteractions/${sid}`;
};

/* jshint ignore:start */
/**
 * fetch a MessageInteractionInstance
 *
 * @function fetch
 * @memberof Twilio.Proxy.V1.ServiceContext.SessionContext.ParticipantContext.MessageInteractionContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed MessageInteractionInstance
 */
/* jshint ignore:end */
MessageInteractionContext.prototype.fetch = function fetch(callback) {
  var deferred = Q.defer();
  var promise = this._version.fetch({uri: this._uri, method: 'GET'});

  promise = promise.then(function(payload) {
    deferred.resolve(new MessageInteractionInstance(
      this._version,
      payload,
      this._solution.serviceSid,
      this._solution.sessionSid,
      this._solution.participantSid,
      this._solution.sid
    ));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Proxy.V1.ServiceContext.SessionContext.ParticipantContext.MessageInteractionContext#
 *
 * @returns Object
 */
/* jshint ignore:end */
MessageInteractionContext.prototype.toJSON = function toJSON() {
  return this._solution;
};

MessageInteractionContext.prototype[util.inspect.custom] = function
    inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  MessageInteractionList: MessageInteractionList,
  MessageInteractionPage: MessageInteractionPage,
  MessageInteractionInstance: MessageInteractionInstance,
  MessageInteractionContext: MessageInteractionContext
};
