/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../../base/Page');
import Response = require('../../../../http/response');
import Wireless = require('../../Wireless');
import { SerializableClass } from '../../../../interfaces';

/**
 * Initialize the UsageList
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @param version - Version of the resource
 * @param simSid - The sim_sid
 */
declare function UsageList(version: Wireless, simSid: string): UsageListInstance;

/**
 * Options to pass to fetch
 *
 * @property end - The end
 * @property start - The start
 */
interface UsageInstanceFetchOptions {
  end?: string;
  start?: string;
}

interface UsageListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): UsageContext;
  /**
   * Constructs a usage
   */
  get(): UsageContext;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

interface UsagePayload extends UsageResource, Page.TwilioResponsePayload {
}

interface UsageResource {
  account_sid: string;
  commands_costs: object;
  commands_usage: object;
  data_costs: object;
  data_usage: object;
  period: object;
  sim_sid: string;
  sim_unique_name: string;
  url: string;
}

interface UsageSolution {
  simSid?: string;
}


declare class UsageContext {
  /**
   * Initialize the UsageContext
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param simSid - The sim_sid
   */
  constructor(version: Wireless, simSid: string);

  /**
   * fetch a UsageInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  fetch(opts?: UsageInstanceFetchOptions, callback?: (error: Error | null, items: UsageInstance) => any): Promise<UsageInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class UsageInstance extends SerializableClass {
  /**
   * Initialize the UsageContext
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param simSid - The sim_sid
   */
  constructor(version: Wireless, payload: UsagePayload, simSid: string);

  private _proxy: UsageContext;
  accountSid: string;
  commandsCosts: object;
  commandsUsage: object;
  dataCosts: object;
  dataUsage: object;
  /**
   * fetch a UsageInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  fetch(opts?: UsageInstanceFetchOptions, callback?: (error: Error | null, items: UsageInstance) => any): Promise<UsageInstance>;
  period: object;
  simSid: string;
  simUniqueName: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  url: string;
}


declare class UsagePage extends Page<Wireless, UsagePayload, UsageResource, UsageInstance> {
  /**
   * Initialize the UsagePage
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: Wireless, response: Response<string>, solution: UsageSolution);

  /**
   * Build an instance of UsageInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: UsagePayload): UsageInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { UsageContext, UsageInstance, UsageInstanceFetchOptions, UsageList, UsageListInstance, UsagePage, UsagePayload, UsageResource, UsageSolution }
