'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var Page = require('../../../base/Page');  /* jshint ignore:line */
var deserialize = require(
    '../../../base/deserialize');  /* jshint ignore:line */
var serialize = require('../../../base/serialize');  /* jshint ignore:line */
var values = require('../../../base/values');  /* jshint ignore:line */

var PhoneCallList;
var PhoneCallPage;
var PhoneCallInstance;

/* jshint ignore:start */
/**
 * Initialize the PhoneCallList
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Preview.TrustedComms.PhoneCallList
 *
 * @param {Twilio.Preview.TrustedComms} version - Version of the resource
 */
/* jshint ignore:end */
PhoneCallList = function PhoneCallList(version) {
  /* jshint ignore:start */
  /**
   * @function phoneCalls
   * @memberof Twilio.Preview.TrustedComms#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Preview.TrustedComms.PhoneCallContext}
   */
  /* jshint ignore:end */
  function PhoneCallListInstance(sid) {
    return PhoneCallListInstance.get(sid);
  }

  PhoneCallListInstance._version = version;
  // Path Solution
  PhoneCallListInstance._solution = {};
  PhoneCallListInstance._uri = `/Business/PhoneCalls`;
  /* jshint ignore:start */
  /**
   * create a PhoneCallInstance
   *
   * @function create
   * @memberof Twilio.Preview.TrustedComms.PhoneCallList#
   *
   * @param {object} opts - Options for request
   * @param {string} opts.from - Twilio number from which to originate the call
   * @param {string} opts.to - The terminating Phone Number
   * @param {string} [opts.reason] - The business reason for this phone call
   * @param {string} [opts.applicationSid] -
   *          Refers to the Voice API Initiate Call parameter
   * @param {string} [opts.callerId] -
   *          Refers to the Voice API Initiate Call parameter
   * @param {string} [opts.fallbackMethod] -
   *          Refers to the Voice API Initiate Call parameter
   * @param {string} [opts.fallbackUrl] -
   *          Refers to the Voice API Initiate Call parameter
   * @param {string} [opts.machineDetection] -
   *          Refers to the Voice API Initiate Call parameter
   * @param {number} [opts.machineDetectionSilenceTimeout] -
   *          Refers to the Voice API Initiate Call parameter
   * @param {number} [opts.machineDetectionSpeechEndThreshold] -
   *          Refers to the Voice API Initiate Call parameter
   * @param {number} [opts.machineDetectionSpeechThreshold] -
   *          Refers to the Voice API Initiate Call parameter
   * @param {number} [opts.machineDetectionTimeout] -
   *          Refers to the Voice API Initiate Call parameter
   * @param {string} [opts.method] - Refers to the Voice API Initiate Call parameter
   * @param {boolean} [opts.record] - Refers to the Voice API Initiate Call parameter
   * @param {string} [opts.recordingChannels] -
   *          Refers to the Voice API Initiate Call parameter
   * @param {string} [opts.recordingStatusCallback] -
   *          Refers to the Voice API Initiate Call parameter
   * @param {string|list} [opts.recordingStatusCallbackEvent] -
   *          Refers to the Voice API Initiate Call parameter
   * @param {string} [opts.recordingStatusCallbackMethod] -
   *          Refers to the Voice API Initiate Call parameter
   * @param {string} [opts.sendDigits] -
   *          Refers to the Voice API Initiate Call parameter
   * @param {string} [opts.sipAuthPassword] -
   *          Refers to the Voice API Initiate Call parameter
   * @param {string} [opts.sipAuthUsername] -
   *          Refers to the Voice API Initiate Call parameter
   * @param {string} [opts.statusCallback] -
   *          Refers to the Voice API Initiate Call parameter
   * @param {string|list} [opts.statusCallbackEvent] -
   *          Refers to the Voice API Initiate Call parameter
   * @param {string} [opts.statusCallbackMethod] -
   *          Refers to the Voice API Initiate Call parameter
   * @param {number} [opts.timeout] - Refers to the Voice API Initiate Call parameter
   * @param {string} [opts.trim] - Refers to the Voice API Initiate Call parameter
   * @param {string} [opts.url] - Refers to the Voice API Initiate Call parameter
   * @param {function} [callback] - Callback to handle processed record
   *
   * @returns {Promise} Resolves to processed PhoneCallInstance
   */
  /* jshint ignore:end */
  PhoneCallListInstance.create = function create(opts, callback) {
    if (_.isUndefined(opts)) {
      throw new Error('Required parameter "opts" missing.');
    }
    if (_.isUndefined(opts.from)) {
      throw new Error('Required parameter "opts.from" missing.');
    }
    if (_.isUndefined(opts.to)) {
      throw new Error('Required parameter "opts.to" missing.');
    }

    var deferred = Q.defer();
    var data = values.of({
      'From': _.get(opts, 'from'),
      'To': _.get(opts, 'to'),
      'Reason': _.get(opts, 'reason'),
      'ApplicationSid': _.get(opts, 'applicationSid'),
      'CallerId': _.get(opts, 'callerId'),
      'FallbackMethod': _.get(opts, 'fallbackMethod'),
      'FallbackUrl': _.get(opts, 'fallbackUrl'),
      'MachineDetection': _.get(opts, 'machineDetection'),
      'MachineDetectionSilenceTimeout': _.get(opts, 'machineDetectionSilenceTimeout'),
      'MachineDetectionSpeechEndThreshold': _.get(opts, 'machineDetectionSpeechEndThreshold'),
      'MachineDetectionSpeechThreshold': _.get(opts, 'machineDetectionSpeechThreshold'),
      'MachineDetectionTimeout': _.get(opts, 'machineDetectionTimeout'),
      'Method': _.get(opts, 'method'),
      'Record': serialize.bool(_.get(opts, 'record')),
      'RecordingChannels': _.get(opts, 'recordingChannels'),
      'RecordingStatusCallback': _.get(opts, 'recordingStatusCallback'),
      'RecordingStatusCallbackEvent': serialize.map(_.get(opts, 'recordingStatusCallbackEvent'), function(e) { return e; }),
      'RecordingStatusCallbackMethod': _.get(opts, 'recordingStatusCallbackMethod'),
      'SendDigits': _.get(opts, 'sendDigits'),
      'SipAuthPassword': _.get(opts, 'sipAuthPassword'),
      'SipAuthUsername': _.get(opts, 'sipAuthUsername'),
      'StatusCallback': _.get(opts, 'statusCallback'),
      'StatusCallbackEvent': serialize.map(_.get(opts, 'statusCallbackEvent'), function(e) { return e; }),
      'StatusCallbackMethod': _.get(opts, 'statusCallbackMethod'),
      'Timeout': _.get(opts, 'timeout'),
      'Trim': _.get(opts, 'trim'),
      'Url': _.get(opts, 'url')
    });

    var promise = this._version.create({uri: this._uri, method: 'POST', data: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new PhoneCallInstance(this._version, payload));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Preview.TrustedComms.PhoneCallList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  PhoneCallListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  PhoneCallListInstance[util.inspect.custom] = function inspect(depth, options) {
    return util.inspect(this.toJSON(), options);
  };

  return PhoneCallListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the PhoneCallPage
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Preview.TrustedComms.PhoneCallPage
 *
 * @param {TrustedComms} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {PhoneCallSolution} solution - Path solution
 *
 * @returns PhoneCallPage
 */
/* jshint ignore:end */
PhoneCallPage = function PhoneCallPage(version, response, solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(PhoneCallPage.prototype, Page.prototype);
PhoneCallPage.prototype.constructor = PhoneCallPage;

/* jshint ignore:start */
/**
 * Build an instance of PhoneCallInstance
 *
 * @function getInstance
 * @memberof Twilio.Preview.TrustedComms.PhoneCallPage#
 *
 * @param {PhoneCallPayload} payload - Payload response from the API
 *
 * @returns PhoneCallInstance
 */
/* jshint ignore:end */
PhoneCallPage.prototype.getInstance = function getInstance(payload) {
  return new PhoneCallInstance(this._version, payload);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Preview.TrustedComms.PhoneCallPage#
 *
 * @returns Object
 */
/* jshint ignore:end */
PhoneCallPage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

PhoneCallPage.prototype[util.inspect.custom] = function inspect(depth, options)
    {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the PhoneCallContext
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Preview.TrustedComms.PhoneCallInstance
 *
 * @property {string} accountSid - Account Sid.
 * @property {string} bgColor - Background color of the current phone call
 * @property {string} brandSid - Brand Sid.
 * @property {string} brandedChannelSid - Branded Channel Sid.
 * @property {string} businessSid - Business Sid.
 * @property {string} callSid - A string that uniquely identifies this phone call.
 * @property {string} caller - Caller name of the current phone call
 * @property {Date} createdAt - The date this Current Call was created
 * @property {string} fontColor - Font color of the current phone call
 * @property {string} from - The originating Phone Number
 * @property {string} logo - Logo URL of the caller
 * @property {string} phoneNumberSid - Phone Number Sid.
 * @property {string} reason - The business reason for this phone call
 * @property {string} sid -
 *          A string that uniquely identifies this current branded phone call.
 * @property {string} status - The status of the current phone call
 * @property {string} to - The terminating Phone Number
 * @property {string} url - The URL of this resource.
 * @property {string} useCase - The use case for the current phone call
 *
 * @param {TrustedComms} version - Version of the resource
 * @param {PhoneCallPayload} payload - The instance payload
 */
/* jshint ignore:end */
PhoneCallInstance = function PhoneCallInstance(version, payload) {
  this._version = version;

  // Marshaled Properties
  this.accountSid = payload.account_sid; // jshint ignore:line
  this.bgColor = payload.bg_color; // jshint ignore:line
  this.brandSid = payload.brand_sid; // jshint ignore:line
  this.brandedChannelSid = payload.branded_channel_sid; // jshint ignore:line
  this.businessSid = payload.business_sid; // jshint ignore:line
  this.callSid = payload.call_sid; // jshint ignore:line
  this.caller = payload.caller; // jshint ignore:line
  this.createdAt = deserialize.iso8601DateTime(payload.created_at); // jshint ignore:line
  this.fontColor = payload.font_color; // jshint ignore:line
  this.from = payload.from; // jshint ignore:line
  this.logo = payload.logo; // jshint ignore:line
  this.phoneNumberSid = payload.phone_number_sid; // jshint ignore:line
  this.reason = payload.reason; // jshint ignore:line
  this.sid = payload.sid; // jshint ignore:line
  this.status = payload.status; // jshint ignore:line
  this.to = payload.to; // jshint ignore:line
  this.url = payload.url; // jshint ignore:line
  this.useCase = payload.use_case; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {};
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Preview.TrustedComms.PhoneCallInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
PhoneCallInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

PhoneCallInstance.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  PhoneCallList: PhoneCallList,
  PhoneCallPage: PhoneCallPage,
  PhoneCallInstance: PhoneCallInstance
};
