/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../base/Page');
import Response = require('../../../http/response');
import TrustedComms = require('../TrustedComms');
import serialize = require('../../../base/serialize');
import { SerializableClass } from '../../../interfaces';

/**
 * Initialize the PhoneCallList
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @param version - Version of the resource
 */
declare function PhoneCallList(version: TrustedComms): PhoneCallListInstance;

interface PhoneCallListInstance {
  /**
   * create a PhoneCallInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  create(opts: PhoneCallListInstanceCreateOptions, callback?: (error: Error | null, item: PhoneCallInstance) => any): Promise<PhoneCallInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to create
 *
 * @property applicationSid - Refers to the Voice API Initiate Call parameter
 * @property callerId - Refers to the Voice API Initiate Call parameter
 * @property fallbackMethod - Refers to the Voice API Initiate Call parameter
 * @property fallbackUrl - Refers to the Voice API Initiate Call parameter
 * @property from - Twilio number from which to originate the call
 * @property machineDetection - Refers to the Voice API Initiate Call parameter
 * @property machineDetectionSilenceTimeout - Refers to the Voice API Initiate Call parameter
 * @property machineDetectionSpeechEndThreshold - Refers to the Voice API Initiate Call parameter
 * @property machineDetectionSpeechThreshold - Refers to the Voice API Initiate Call parameter
 * @property machineDetectionTimeout - Refers to the Voice API Initiate Call parameter
 * @property method - Refers to the Voice API Initiate Call parameter
 * @property reason - The business reason for this phone call
 * @property record - Refers to the Voice API Initiate Call parameter
 * @property recordingChannels - Refers to the Voice API Initiate Call parameter
 * @property recordingStatusCallback - Refers to the Voice API Initiate Call parameter
 * @property recordingStatusCallbackEvent - Refers to the Voice API Initiate Call parameter
 * @property recordingStatusCallbackMethod - Refers to the Voice API Initiate Call parameter
 * @property sendDigits - Refers to the Voice API Initiate Call parameter
 * @property sipAuthPassword - Refers to the Voice API Initiate Call parameter
 * @property sipAuthUsername - Refers to the Voice API Initiate Call parameter
 * @property statusCallback - Refers to the Voice API Initiate Call parameter
 * @property statusCallbackEvent - Refers to the Voice API Initiate Call parameter
 * @property statusCallbackMethod - Refers to the Voice API Initiate Call parameter
 * @property timeout - Refers to the Voice API Initiate Call parameter
 * @property to - The terminating Phone Number
 * @property trim - Refers to the Voice API Initiate Call parameter
 * @property url - Refers to the Voice API Initiate Call parameter
 */
interface PhoneCallListInstanceCreateOptions {
  applicationSid?: string;
  callerId?: string;
  fallbackMethod?: string;
  fallbackUrl?: string;
  from: string;
  machineDetection?: string;
  machineDetectionSilenceTimeout?: number;
  machineDetectionSpeechEndThreshold?: number;
  machineDetectionSpeechThreshold?: number;
  machineDetectionTimeout?: number;
  method?: string;
  reason?: string;
  record?: boolean;
  recordingChannels?: string;
  recordingStatusCallback?: string;
  recordingStatusCallbackEvent?: string | string[];
  recordingStatusCallbackMethod?: string;
  sendDigits?: string;
  sipAuthPassword?: string;
  sipAuthUsername?: string;
  statusCallback?: string;
  statusCallbackEvent?: string | string[];
  statusCallbackMethod?: string;
  timeout?: number;
  to: string;
  trim?: string;
  url?: string;
}

interface PhoneCallPayload extends PhoneCallResource, Page.TwilioResponsePayload {
}

interface PhoneCallResource {
  account_sid: string;
  bg_color: string;
  brand_sid: string;
  branded_channel_sid: string;
  business_sid: string;
  call_sid: string;
  caller: string;
  created_at: Date;
  font_color: string;
  from: string;
  logo: string;
  phone_number_sid: string;
  reason: string;
  sid: string;
  status: string;
  to: string;
  url: string;
  use_case: string;
}

interface PhoneCallSolution {
}


declare class PhoneCallInstance extends SerializableClass {
  /**
   * Initialize the PhoneCallContext
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   */
  constructor(version: TrustedComms, payload: PhoneCallPayload);

  accountSid: string;
  bgColor: string;
  brandSid: string;
  brandedChannelSid: string;
  businessSid: string;
  callSid: string;
  caller: string;
  createdAt: Date;
  fontColor: string;
  from: string;
  logo: string;
  phoneNumberSid: string;
  reason: string;
  sid: string;
  status: string;
  to: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  url: string;
  useCase: string;
}


declare class PhoneCallPage extends Page<TrustedComms, PhoneCallPayload, PhoneCallResource, PhoneCallInstance> {
  /**
   * Initialize the PhoneCallPage
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: TrustedComms, response: Response<string>, solution: PhoneCallSolution);

  /**
   * Build an instance of PhoneCallInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: PhoneCallPayload): PhoneCallInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { PhoneCallInstance, PhoneCallList, PhoneCallListInstance, PhoneCallListInstanceCreateOptions, PhoneCallPage, PhoneCallPayload, PhoneCallResource, PhoneCallSolution }
