'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var SuccessRateList = require('./insights/successRate').SuccessRateList;

var InsightsList;

/* jshint ignore:start */
/**
 * Initialize the InsightsList
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Preview.TrustedComms.BusinessContext.InsightsList
 *
 * @param {Twilio.Preview.TrustedComms} version - Version of the resource
 * @param {string} businessSid - A string that uniquely identifies this Business.
 */
/* jshint ignore:end */
InsightsList = function InsightsList(version, businessSid) {
  /* jshint ignore:start */
  /**
   * @function insights
   * @memberof Twilio.Preview.TrustedComms.BusinessContext#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Preview.TrustedComms.BusinessContext.InsightsContext}
   */
  /* jshint ignore:end */
  function InsightsListInstance(sid) {
    return InsightsListInstance.get(sid);
  }

  InsightsListInstance._version = version;
  // Path Solution
  InsightsListInstance._solution = {businessSid: businessSid};

  // Components
  InsightsListInstance._successRate = undefined;

  Object.defineProperty(InsightsListInstance,
    'successRate', {
      get: function successRate() {
        if (!this._successRate) {
          this._successRate = new SuccessRateList(this._version, this._solution.businessSid);
        }

        return this._successRate;
      }
  });

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Preview.TrustedComms.BusinessContext.InsightsList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  InsightsListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  InsightsListInstance[util.inspect.custom] = function inspect(depth, options) {
    return util.inspect(this.toJSON(), options);
  };

  return InsightsListInstance;
};

module.exports = {
  InsightsList: InsightsList
};
