'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var InsightsList = require('./business/insights').InsightsList;
var Page = require('../../../base/Page');  /* jshint ignore:line */
var values = require('../../../base/values');  /* jshint ignore:line */

var BusinessList;
var BusinessPage;
var BusinessInstance;
var BusinessContext;

/* jshint ignore:start */
/**
 * Initialize the BusinessList
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Preview.TrustedComms.BusinessList
 *
 * @param {Twilio.Preview.TrustedComms} version - Version of the resource
 */
/* jshint ignore:end */
BusinessList = function BusinessList(version) {
  /* jshint ignore:start */
  /**
   * @function businesses
   * @memberof Twilio.Preview.TrustedComms#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Preview.TrustedComms.BusinessContext}
   */
  /* jshint ignore:end */
  function BusinessListInstance(sid) {
    return BusinessListInstance.get(sid);
  }

  BusinessListInstance._version = version;
  // Path Solution
  BusinessListInstance._solution = {};
  /* jshint ignore:start */
  /**
   * Constructs a business
   *
   * @function get
   * @memberof Twilio.Preview.TrustedComms.BusinessList#
   *
   * @param {string} sid - A string that uniquely identifies this Business.
   *
   * @returns {Twilio.Preview.TrustedComms.BusinessContext}
   */
  /* jshint ignore:end */
  BusinessListInstance.get = function get(sid) {
    return new BusinessContext(this._version, sid);
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Preview.TrustedComms.BusinessList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  BusinessListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  BusinessListInstance[util.inspect.custom] = function inspect(depth, options) {
    return util.inspect(this.toJSON(), options);
  };

  return BusinessListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the BusinessPage
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Preview.TrustedComms.BusinessPage
 *
 * @param {TrustedComms} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {BusinessSolution} solution - Path solution
 *
 * @returns BusinessPage
 */
/* jshint ignore:end */
BusinessPage = function BusinessPage(version, response, solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(BusinessPage.prototype, Page.prototype);
BusinessPage.prototype.constructor = BusinessPage;

/* jshint ignore:start */
/**
 * Build an instance of BusinessInstance
 *
 * @function getInstance
 * @memberof Twilio.Preview.TrustedComms.BusinessPage#
 *
 * @param {BusinessPayload} payload - Payload response from the API
 *
 * @returns BusinessInstance
 */
/* jshint ignore:end */
BusinessPage.prototype.getInstance = function getInstance(payload) {
  return new BusinessInstance(this._version, payload);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Preview.TrustedComms.BusinessPage#
 *
 * @returns Object
 */
/* jshint ignore:end */
BusinessPage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

BusinessPage.prototype[util.inspect.custom] = function inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the BusinessContext
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Preview.TrustedComms.BusinessInstance
 *
 * @property {string} accountSid - Account Sid.
 * @property {string} sid - A string that uniquely identifies this Business.
 * @property {string} url - The URL of this resource.
 * @property {string} links - Nested resource URLs.
 *
 * @param {TrustedComms} version - Version of the resource
 * @param {BusinessPayload} payload - The instance payload
 * @param {sid} sid - A string that uniquely identifies this Business.
 */
/* jshint ignore:end */
BusinessInstance = function BusinessInstance(version, payload, sid) {
  this._version = version;

  // Marshaled Properties
  this.accountSid = payload.account_sid; // jshint ignore:line
  this.sid = payload.sid; // jshint ignore:line
  this.url = payload.url; // jshint ignore:line
  this.links = payload.links; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {sid: sid || this.sid, };
};

Object.defineProperty(BusinessInstance.prototype,
  '_proxy', {
    get: function() {
      if (!this._context) {
        this._context = new BusinessContext(this._version, this._solution.sid);
      }

      return this._context;
    }
});

/* jshint ignore:start */
/**
 * fetch a BusinessInstance
 *
 * @function fetch
 * @memberof Twilio.Preview.TrustedComms.BusinessInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed BusinessInstance
 */
/* jshint ignore:end */
BusinessInstance.prototype.fetch = function fetch(callback) {
  return this._proxy.fetch(callback);
};

/* jshint ignore:start */
/**
 * Access the insights
 *
 * @function insights
 * @memberof Twilio.Preview.TrustedComms.BusinessInstance#
 *
 * @returns {Twilio.Preview.TrustedComms.BusinessContext.InsightsList}
 */
/* jshint ignore:end */
BusinessInstance.prototype.insights = function insights() {
  return this._proxy.insights;
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Preview.TrustedComms.BusinessInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
BusinessInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

BusinessInstance.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the BusinessContext
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Preview.TrustedComms.BusinessContext
 *
 * @property {Twilio.Preview.TrustedComms.BusinessContext.InsightsList} insights -
 *          insights resource
 *
 * @param {TrustedComms} version - Version of the resource
 * @param {sid} sid - A string that uniquely identifies this Business.
 */
/* jshint ignore:end */
BusinessContext = function BusinessContext(version, sid) {
  this._version = version;

  // Path Solution
  this._solution = {sid: sid, };
  this._uri = `/Businesses/${sid}`;

  // Dependents
  this._insights = undefined;
};

/* jshint ignore:start */
/**
 * fetch a BusinessInstance
 *
 * @function fetch
 * @memberof Twilio.Preview.TrustedComms.BusinessContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed BusinessInstance
 */
/* jshint ignore:end */
BusinessContext.prototype.fetch = function fetch(callback) {
  var deferred = Q.defer();
  var promise = this._version.fetch({uri: this._uri, method: 'GET'});

  promise = promise.then(function(payload) {
    deferred.resolve(new BusinessInstance(this._version, payload, this._solution.sid));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

Object.defineProperty(BusinessContext.prototype,
  'insights', {
    get: function() {
      if (!this._insights) {
        this._insights = new InsightsList(this._version, this._solution.sid);
      }
      return this._insights;
    }
});

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Preview.TrustedComms.BusinessContext#
 *
 * @returns Object
 */
/* jshint ignore:end */
BusinessContext.prototype.toJSON = function toJSON() {
  return this._solution;
};

BusinessContext.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  BusinessList: BusinessList,
  BusinessPage: BusinessPage,
  BusinessInstance: BusinessInstance,
  BusinessContext: BusinessContext
};
