/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../base/Page');
import Response = require('../../../http/response');
import TrustedComms = require('../TrustedComms');
import { InsightsList } from './business/insights';
import { InsightsListInstance } from './business/insights';
import { SerializableClass } from '../../../interfaces';

/**
 * Initialize the BusinessList
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @param version - Version of the resource
 */
declare function BusinessList(version: TrustedComms): BusinessListInstance;

interface BusinessListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): BusinessContext;
  /**
   * Constructs a business
   *
   * @param sid - A string that uniquely identifies this Business.
   */
  get(sid: string): BusinessContext;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

interface BusinessPayload extends BusinessResource, Page.TwilioResponsePayload {
}

interface BusinessResource {
  account_sid: string;
  links: string;
  sid: string;
  url: string;
}

interface BusinessSolution {
}


declare class BusinessContext {
  /**
   * Initialize the BusinessContext
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param sid - A string that uniquely identifies this Business.
   */
  constructor(version: TrustedComms, sid: string);

  /**
   * fetch a BusinessInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: BusinessInstance) => any): Promise<BusinessInstance>;
  insights: InsightsListInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class BusinessInstance extends SerializableClass {
  /**
   * Initialize the BusinessContext
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param sid - A string that uniquely identifies this Business.
   */
  constructor(version: TrustedComms, payload: BusinessPayload, sid: string);

  private _proxy: BusinessContext;
  accountSid: string;
  /**
   * fetch a BusinessInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: BusinessInstance) => any): Promise<BusinessInstance>;
  /**
   * Access the insights
   */
  insights(): InsightsListInstance;
  links: string;
  sid: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  url: string;
}


declare class BusinessPage extends Page<TrustedComms, BusinessPayload, BusinessResource, BusinessInstance> {
  /**
   * Initialize the BusinessPage
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: TrustedComms, response: Response<string>, solution: BusinessSolution);

  /**
   * Build an instance of BusinessInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: BusinessPayload): BusinessInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { BusinessContext, BusinessInstance, BusinessList, BusinessListInstance, BusinessPage, BusinessPayload, BusinessResource, BusinessSolution }
