'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var Page = require('../../../base/Page');  /* jshint ignore:line */
var deserialize = require(
    '../../../base/deserialize');  /* jshint ignore:line */
var values = require('../../../base/values');  /* jshint ignore:line */

var BrandedCallList;
var BrandedCallPage;
var BrandedCallInstance;

/* jshint ignore:start */
/**
 * Initialize the BrandedCallList
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Preview.TrustedComms.BrandedCallList
 *
 * @param {Twilio.Preview.TrustedComms} version - Version of the resource
 */
/* jshint ignore:end */
BrandedCallList = function BrandedCallList(version) {
  /* jshint ignore:start */
  /**
   * @function brandedCalls
   * @memberof Twilio.Preview.TrustedComms#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Preview.TrustedComms.BrandedCallContext}
   */
  /* jshint ignore:end */
  function BrandedCallListInstance(sid) {
    return BrandedCallListInstance.get(sid);
  }

  BrandedCallListInstance._version = version;
  // Path Solution
  BrandedCallListInstance._solution = {};
  BrandedCallListInstance._uri = `/Business/BrandedCalls`;
  /* jshint ignore:start */
  /**
   * create a BrandedCallInstance
   *
   * @function create
   * @memberof Twilio.Preview.TrustedComms.BrandedCallList#
   *
   * @param {object} opts - Options for request
   * @param {string} opts.from - Twilio number from which to brand the call
   * @param {string} opts.to - The terminating Phone Number
   * @param {string} opts.reason - The business reason for this phone call
   * @param {string} [opts.callSid] - The Call sid this Branded Call should link to
   * @param {function} [callback] - Callback to handle processed record
   *
   * @returns {Promise} Resolves to processed BrandedCallInstance
   */
  /* jshint ignore:end */
  BrandedCallListInstance.create = function create(opts, callback) {
    if (_.isUndefined(opts)) {
      throw new Error('Required parameter "opts" missing.');
    }
    if (_.isUndefined(opts.from)) {
      throw new Error('Required parameter "opts.from" missing.');
    }
    if (_.isUndefined(opts.to)) {
      throw new Error('Required parameter "opts.to" missing.');
    }
    if (_.isUndefined(opts.reason)) {
      throw new Error('Required parameter "opts.reason" missing.');
    }

    var deferred = Q.defer();
    var data = values.of({
      'From': _.get(opts, 'from'),
      'To': _.get(opts, 'to'),
      'Reason': _.get(opts, 'reason'),
      'CallSid': _.get(opts, 'callSid')
    });

    var promise = this._version.create({uri: this._uri, method: 'POST', data: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new BrandedCallInstance(this._version, payload));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Preview.TrustedComms.BrandedCallList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  BrandedCallListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  BrandedCallListInstance[util.inspect.custom] = function inspect(depth, options)
      {
    return util.inspect(this.toJSON(), options);
  };

  return BrandedCallListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the BrandedCallPage
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Preview.TrustedComms.BrandedCallPage
 *
 * @param {TrustedComms} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {BrandedCallSolution} solution - Path solution
 *
 * @returns BrandedCallPage
 */
/* jshint ignore:end */
BrandedCallPage = function BrandedCallPage(version, response, solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(BrandedCallPage.prototype, Page.prototype);
BrandedCallPage.prototype.constructor = BrandedCallPage;

/* jshint ignore:start */
/**
 * Build an instance of BrandedCallInstance
 *
 * @function getInstance
 * @memberof Twilio.Preview.TrustedComms.BrandedCallPage#
 *
 * @param {BrandedCallPayload} payload - Payload response from the API
 *
 * @returns BrandedCallInstance
 */
/* jshint ignore:end */
BrandedCallPage.prototype.getInstance = function getInstance(payload) {
  return new BrandedCallInstance(this._version, payload);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Preview.TrustedComms.BrandedCallPage#
 *
 * @returns Object
 */
/* jshint ignore:end */
BrandedCallPage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

BrandedCallPage.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the BrandedCallContext
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Preview.TrustedComms.BrandedCallInstance
 *
 * @property {string} accountSid - Account Sid.
 * @property {string} bgColor - Background color of the current phone call
 * @property {string} brandSid - Brand Sid.
 * @property {string} brandedChannelSid - Branded Channel Sid.
 * @property {string} businessSid - Business Sid.
 * @property {string} callSid - A string that uniquely identifies this phone call.
 * @property {string} caller - Caller name of the current phone call
 * @property {Date} createdAt - The date this current phone call was created
 * @property {string} fontColor - Font color of the current phone call
 * @property {string} from - The originating phone number
 * @property {string} logo - Logo URL of the caller
 * @property {string} phoneNumberSid - Phone Number Sid.
 * @property {string} reason - The business reason for this current phone call
 * @property {string} sid -
 *          A string that uniquely identifies this current branded phone call.
 * @property {string} status - The status of the current phone call
 * @property {string} to - The terminating phone number
 * @property {string} url - The URL of this resource.
 * @property {string} useCase - The use case for the current phone call
 *
 * @param {TrustedComms} version - Version of the resource
 * @param {BrandedCallPayload} payload - The instance payload
 */
/* jshint ignore:end */
BrandedCallInstance = function BrandedCallInstance(version, payload) {
  this._version = version;

  // Marshaled Properties
  this.accountSid = payload.account_sid; // jshint ignore:line
  this.bgColor = payload.bg_color; // jshint ignore:line
  this.brandSid = payload.brand_sid; // jshint ignore:line
  this.brandedChannelSid = payload.branded_channel_sid; // jshint ignore:line
  this.businessSid = payload.business_sid; // jshint ignore:line
  this.callSid = payload.call_sid; // jshint ignore:line
  this.caller = payload.caller; // jshint ignore:line
  this.createdAt = deserialize.iso8601DateTime(payload.created_at); // jshint ignore:line
  this.fontColor = payload.font_color; // jshint ignore:line
  this.from = payload.from; // jshint ignore:line
  this.logo = payload.logo; // jshint ignore:line
  this.phoneNumberSid = payload.phone_number_sid; // jshint ignore:line
  this.reason = payload.reason; // jshint ignore:line
  this.sid = payload.sid; // jshint ignore:line
  this.status = payload.status; // jshint ignore:line
  this.to = payload.to; // jshint ignore:line
  this.url = payload.url; // jshint ignore:line
  this.useCase = payload.use_case; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {};
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Preview.TrustedComms.BrandedCallInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
BrandedCallInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

BrandedCallInstance.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  BrandedCallList: BrandedCallList,
  BrandedCallPage: BrandedCallPage,
  BrandedCallInstance: BrandedCallInstance
};
