/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../base/Page');
import Response = require('../../../http/response');
import TrustedComms = require('../TrustedComms');
import { SerializableClass } from '../../../interfaces';

/**
 * Initialize the BrandedCallList
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @param version - Version of the resource
 */
declare function BrandedCallList(version: TrustedComms): BrandedCallListInstance;

interface BrandedCallListInstance {
  /**
   * create a BrandedCallInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  create(opts: BrandedCallListInstanceCreateOptions, callback?: (error: Error | null, item: BrandedCallInstance) => any): Promise<BrandedCallInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to create
 *
 * @property callSid - The Call sid this Branded Call should link to
 * @property from - Twilio number from which to brand the call
 * @property reason - The business reason for this phone call
 * @property to - The terminating Phone Number
 */
interface BrandedCallListInstanceCreateOptions {
  callSid?: string;
  from: string;
  reason: string;
  to: string;
}

interface BrandedCallPayload extends BrandedCallResource, Page.TwilioResponsePayload {
}

interface BrandedCallResource {
  account_sid: string;
  bg_color: string;
  brand_sid: string;
  branded_channel_sid: string;
  business_sid: string;
  call_sid: string;
  caller: string;
  created_at: Date;
  font_color: string;
  from: string;
  logo: string;
  phone_number_sid: string;
  reason: string;
  sid: string;
  status: string;
  to: string;
  url: string;
  use_case: string;
}

interface BrandedCallSolution {
}


declare class BrandedCallInstance extends SerializableClass {
  /**
   * Initialize the BrandedCallContext
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   */
  constructor(version: TrustedComms, payload: BrandedCallPayload);

  accountSid: string;
  bgColor: string;
  brandSid: string;
  brandedChannelSid: string;
  businessSid: string;
  callSid: string;
  caller: string;
  createdAt: Date;
  fontColor: string;
  from: string;
  logo: string;
  phoneNumberSid: string;
  reason: string;
  sid: string;
  status: string;
  to: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  url: string;
  useCase: string;
}


declare class BrandedCallPage extends Page<TrustedComms, BrandedCallPayload, BrandedCallResource, BrandedCallInstance> {
  /**
   * Initialize the BrandedCallPage
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: TrustedComms, response: Response<string>, solution: BrandedCallSolution);

  /**
   * Build an instance of BrandedCallInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: BrandedCallPayload): BrandedCallInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { BrandedCallInstance, BrandedCallList, BrandedCallListInstance, BrandedCallListInstanceCreateOptions, BrandedCallPage, BrandedCallPayload, BrandedCallResource, BrandedCallSolution }
