/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import DeployedDevices = require('../../DeployedDevices');
import Page = require('../../../../base/Page');
import Response = require('../../../../http/response');
import { SerializableClass } from '../../../../interfaces';

/**
 * Initialize the KeyList
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @param version - Version of the resource
 * @param fleetSid - The unique identifier of the Fleet.
 */
declare function KeyList(version: DeployedDevices, fleetSid: string): KeyListInstance;

/**
 * Options to pass to update
 *
 * @property deviceSid - The unique identifier of a Key to be authenticated.
 * @property friendlyName - The human readable description for this Key.
 */
interface KeyInstanceUpdateOptions {
  deviceSid?: string;
  friendlyName?: string;
}

interface KeyListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): KeyContext;
  /**
   * create a KeyInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  create(opts?: KeyListInstanceCreateOptions, callback?: (error: Error | null, item: KeyInstance) => any): Promise<KeyInstance>;
  /**
   * Streams KeyInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Function to process each record
   */
  each(opts?: KeyListInstanceEachOptions, callback?: (item: KeyInstance, done: (err?: Error) => void) => void): void;
  /**
   * Constructs a key
   *
   * @param sid - A string that uniquely identifies the Key.
   */
  get(sid: string): KeyContext;
  /**
   * Retrieve a single target page of KeyInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param targetUrl - API-generated URL for the requested results page
   * @param callback - Callback to handle list of records
   */
  getPage(targetUrl?: string, callback?: (error: Error | null, items: KeyPage) => any): Promise<KeyPage>;
  /**
   * Lists KeyInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  list(opts?: KeyListInstanceOptions, callback?: (error: Error | null, items: KeyInstance[]) => any): Promise<KeyInstance[]>;
  /**
   * Retrieve a single page of KeyInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  page(opts?: KeyListInstancePageOptions, callback?: (error: Error | null, items: KeyPage) => any): Promise<KeyPage>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to create
 *
 * @property deviceSid - The unique identifier of a Key to be authenticated.
 * @property friendlyName - The human readable description for this Key.
 */
interface KeyListInstanceCreateOptions {
  deviceSid?: string;
  friendlyName?: string;
}

/**
 * Options to pass to each
 *
 * @property callback -
 *                         Function to process each record. If this and a positional
 *                         callback are passed, this one will be used
 * @property deviceSid - Find all Keys authenticating specified Device.
 * @property done - Function to be called upon completion of streaming
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         each() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no pageSize is defined but a limit is defined,
 *                         each() will attempt to read the limit with the most efficient
 *                         page size, i.e. min(limit, 1000)
 */
interface KeyListInstanceEachOptions {
  callback?: (item: KeyInstance, done: (err?: Error) => void) => void;
  deviceSid?: string;
  done?: Function;
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to list
 *
 * @property deviceSid - Find all Keys authenticating specified Device.
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         list() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no page_size is defined but a limit is defined,
 *                         list() will attempt to read the limit with the most
 *                         efficient page size, i.e. min(limit, 1000)
 */
interface KeyListInstanceOptions {
  deviceSid?: string;
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to page
 *
 * @property deviceSid - Find all Keys authenticating specified Device.
 * @property pageNumber - Page Number, this value is simply for client state
 * @property pageSize - Number of records to return, defaults to 50
 * @property pageToken - PageToken provided by the API
 */
interface KeyListInstancePageOptions {
  deviceSid?: string;
  pageNumber?: number;
  pageSize?: number;
  pageToken?: string;
}

interface KeyPayload extends KeyResource, Page.TwilioResponsePayload {
}

interface KeyResource {
  account_sid: string;
  date_created: Date;
  date_updated: Date;
  device_sid: string;
  fleet_sid: string;
  friendly_name: string;
  secret: string;
  sid: string;
  url: string;
}

interface KeySolution {
  fleetSid?: string;
}


declare class KeyContext {
  /**
   * Initialize the KeyContext
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param fleetSid - The fleet_sid
   * @param sid - A string that uniquely identifies the Key.
   */
  constructor(version: DeployedDevices, fleetSid: string, sid: string);

  /**
   * fetch a KeyInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: KeyInstance) => any): Promise<KeyInstance>;
  /**
   * remove a KeyInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: KeyInstance) => any): Promise<boolean>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a KeyInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: KeyInstanceUpdateOptions, callback?: (error: Error | null, items: KeyInstance) => any): Promise<KeyInstance>;
}


declare class KeyInstance extends SerializableClass {
  /**
   * Initialize the KeyContext
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param fleetSid - The unique identifier of the Fleet.
   * @param sid - A string that uniquely identifies the Key.
   */
  constructor(version: DeployedDevices, payload: KeyPayload, fleetSid: string, sid: string);

  private _proxy: KeyContext;
  accountSid: string;
  dateCreated: Date;
  dateUpdated: Date;
  deviceSid: string;
  /**
   * fetch a KeyInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: KeyInstance) => any): Promise<KeyInstance>;
  fleetSid: string;
  friendlyName: string;
  /**
   * remove a KeyInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: KeyInstance) => any): Promise<boolean>;
  secret: string;
  sid: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a KeyInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: KeyInstanceUpdateOptions, callback?: (error: Error | null, items: KeyInstance) => any): Promise<KeyInstance>;
  url: string;
}


declare class KeyPage extends Page<DeployedDevices, KeyPayload, KeyResource, KeyInstance> {
  /**
   * Initialize the KeyPage
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: DeployedDevices, response: Response<string>, solution: KeySolution);

  /**
   * Build an instance of KeyInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: KeyPayload): KeyInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { KeyContext, KeyInstance, KeyInstanceUpdateOptions, KeyList, KeyListInstance, KeyListInstanceCreateOptions, KeyListInstanceEachOptions, KeyListInstanceOptions, KeyListInstancePageOptions, KeyPage, KeyPayload, KeyResource, KeySolution }
