'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var CertificateList = require('./fleet/certificate').CertificateList;
var DeploymentList = require('./fleet/deployment').DeploymentList;
var DeviceList = require('./fleet/device').DeviceList;
var KeyList = require('./fleet/key').KeyList;
var Page = require('../../../base/Page');  /* jshint ignore:line */
var deserialize = require(
    '../../../base/deserialize');  /* jshint ignore:line */
var values = require('../../../base/values');  /* jshint ignore:line */

var FleetList;
var FleetPage;
var FleetInstance;
var FleetContext;

/* jshint ignore:start */
/**
 * Initialize the FleetList
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Preview.DeployedDevices.FleetList
 *
 * @param {Twilio.Preview.DeployedDevices} version - Version of the resource
 */
/* jshint ignore:end */
FleetList = function FleetList(version) {
  /* jshint ignore:start */
  /**
   * @function fleets
   * @memberof Twilio.Preview.DeployedDevices#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Preview.DeployedDevices.FleetContext}
   */
  /* jshint ignore:end */
  function FleetListInstance(sid) {
    return FleetListInstance.get(sid);
  }

  FleetListInstance._version = version;
  // Path Solution
  FleetListInstance._solution = {};
  FleetListInstance._uri = `/Fleets`;
  /* jshint ignore:start */
  /**
   * create a FleetInstance
   *
   * @function create
   * @memberof Twilio.Preview.DeployedDevices.FleetList#
   *
   * @param {object} [opts] - Options for request
   * @param {string} [opts.friendlyName] -
   *          A human readable description for this Fleet.
   * @param {function} [callback] - Callback to handle processed record
   *
   * @returns {Promise} Resolves to processed FleetInstance
   */
  /* jshint ignore:end */
  FleetListInstance.create = function create(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};

    var deferred = Q.defer();
    var data = values.of({'FriendlyName': _.get(opts, 'friendlyName')});

    var promise = this._version.create({uri: this._uri, method: 'POST', data: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new FleetInstance(this._version, payload, this._solution.sid));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Streams FleetInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function each
   * @memberof Twilio.Preview.DeployedDevices.FleetList#
   *
   * @param {object} [opts] - Options for request
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         each() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no pageSize is defined but a limit is defined,
   *         each() will attempt to read the limit with the most efficient
   *         page size, i.e. min(limit, 1000)
   * @param {Function} [opts.callback] -
   *         Function to process each record. If this and a positional
   *         callback are passed, this one will be used
   * @param {Function} [opts.done] -
   *          Function to be called upon completion of streaming
   * @param {Function} [callback] - Function to process each record
   */
  /* jshint ignore:end */
  FleetListInstance.each = function each(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    if (opts.callback) {
      callback = opts.callback;
    }
    if (_.isUndefined(callback)) {
      throw new Error('Callback function must be provided');
    }

    var done = false;
    var currentPage = 1;
    var currentResource = 0;
    var limits = this._version.readLimits({
      limit: opts.limit,
      pageSize: opts.pageSize
    });

    function onComplete(error) {
      done = true;
      if (_.isFunction(opts.done)) {
        opts.done(error);
      }
    }

    function fetchNextPage(fn) {
      var promise = fn();
      if (_.isUndefined(promise)) {
        onComplete();
        return;
      }

      promise.then(function(page) {
        _.each(page.instances, function(instance) {
          if (done || (!_.isUndefined(opts.limit) && currentResource >= opts.limit)) {
            done = true;
            return false;
          }

          currentResource++;
          callback(instance, onComplete);
        });

        if ((limits.pageLimit && limits.pageLimit <= currentPage)) {
          onComplete();
        } else if (!done) {
          currentPage++;
          fetchNextPage(_.bind(page.nextPage, page));
        }
      });

      promise.catch(onComplete);
    }

    fetchNextPage(_.bind(this.page, this, _.merge(opts, limits)));
  };

  /* jshint ignore:start */
  /**
   * Lists FleetInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function list
   * @memberof Twilio.Preview.DeployedDevices.FleetList#
   *
   * @param {object} [opts] - Options for request
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         list() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no page_size is defined but a limit is defined,
   *         list() will attempt to read the limit with the most
   *         efficient page size, i.e. min(limit, 1000)
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  FleetListInstance.list = function list(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    var deferred = Q.defer();
    var allResources = [];
    opts.callback = function(resource, done) {
      allResources.push(resource);

      if (!_.isUndefined(opts.limit) && allResources.length === opts.limit) {
        done();
      }
    };

    opts.done = function(error) {
      if (_.isUndefined(error)) {
        deferred.resolve(allResources);
      } else {
        deferred.reject(error);
      }
    };

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    this.each(opts);
    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single page of FleetInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function page
   * @memberof Twilio.Preview.DeployedDevices.FleetList#
   *
   * @param {object} [opts] - Options for request
   * @param {string} [opts.pageToken] - PageToken provided by the API
   * @param {number} [opts.pageNumber] -
   *          Page Number, this value is simply for client state
   * @param {number} [opts.pageSize] - Number of records to return, defaults to 50
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  FleetListInstance.page = function page(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};

    var deferred = Q.defer();
    var data = values.of({
      'PageToken': opts.pageToken,
      'Page': opts.pageNumber,
      'PageSize': opts.pageSize
    });

    var promise = this._version.page({uri: this._uri, method: 'GET', params: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new FleetPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single target page of FleetInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function getPage
   * @memberof Twilio.Preview.DeployedDevices.FleetList#
   *
   * @param {string} [targetUrl] - API-generated URL for the requested results page
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  FleetListInstance.getPage = function getPage(targetUrl, callback) {
    var deferred = Q.defer();

    var promise = this._version._domain.twilio.request({method: 'GET', uri: targetUrl});

    promise = promise.then(function(payload) {
      deferred.resolve(new FleetPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Constructs a fleet
   *
   * @function get
   * @memberof Twilio.Preview.DeployedDevices.FleetList#
   *
   * @param {string} sid - A string that uniquely identifies the Fleet.
   *
   * @returns {Twilio.Preview.DeployedDevices.FleetContext}
   */
  /* jshint ignore:end */
  FleetListInstance.get = function get(sid) {
    return new FleetContext(this._version, sid);
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Preview.DeployedDevices.FleetList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  FleetListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  FleetListInstance[util.inspect.custom] = function inspect(depth, options) {
    return util.inspect(this.toJSON(), options);
  };

  return FleetListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the FleetPage
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Preview.DeployedDevices.FleetPage
 *
 * @param {DeployedDevices} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {FleetSolution} solution - Path solution
 *
 * @returns FleetPage
 */
/* jshint ignore:end */
FleetPage = function FleetPage(version, response, solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(FleetPage.prototype, Page.prototype);
FleetPage.prototype.constructor = FleetPage;

/* jshint ignore:start */
/**
 * Build an instance of FleetInstance
 *
 * @function getInstance
 * @memberof Twilio.Preview.DeployedDevices.FleetPage#
 *
 * @param {FleetPayload} payload - Payload response from the API
 *
 * @returns FleetInstance
 */
/* jshint ignore:end */
FleetPage.prototype.getInstance = function getInstance(payload) {
  return new FleetInstance(this._version, payload);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Preview.DeployedDevices.FleetPage#
 *
 * @returns Object
 */
/* jshint ignore:end */
FleetPage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

FleetPage.prototype[util.inspect.custom] = function inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the FleetContext
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Preview.DeployedDevices.FleetInstance
 *
 * @property {string} sid - A string that uniquely identifies this Fleet.
 * @property {string} url - URL of this Fleet.
 * @property {string} uniqueName - A unique, addressable name of this Fleet.
 * @property {string} friendlyName - A human readable description for this Fleet.
 * @property {string} accountSid - The unique SID that identifies this Account.
 * @property {string} defaultDeploymentSid -
 *          The unique SID that identifies this Fleet's default Deployment.
 * @property {Date} dateCreated - The date this Fleet was created.
 * @property {Date} dateUpdated - The date this Fleet was updated.
 * @property {string} links - Nested resource URLs.
 *
 * @param {DeployedDevices} version - Version of the resource
 * @param {FleetPayload} payload - The instance payload
 * @param {sid_like} sid - A string that uniquely identifies the Fleet.
 */
/* jshint ignore:end */
FleetInstance = function FleetInstance(version, payload, sid) {
  this._version = version;

  // Marshaled Properties
  this.sid = payload.sid; // jshint ignore:line
  this.url = payload.url; // jshint ignore:line
  this.uniqueName = payload.unique_name; // jshint ignore:line
  this.friendlyName = payload.friendly_name; // jshint ignore:line
  this.accountSid = payload.account_sid; // jshint ignore:line
  this.defaultDeploymentSid = payload.default_deployment_sid; // jshint ignore:line
  this.dateCreated = deserialize.iso8601DateTime(payload.date_created); // jshint ignore:line
  this.dateUpdated = deserialize.iso8601DateTime(payload.date_updated); // jshint ignore:line
  this.links = payload.links; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {sid: sid || this.sid, };
};

Object.defineProperty(FleetInstance.prototype,
  '_proxy', {
    get: function() {
      if (!this._context) {
        this._context = new FleetContext(this._version, this._solution.sid);
      }

      return this._context;
    }
});

/* jshint ignore:start */
/**
 * fetch a FleetInstance
 *
 * @function fetch
 * @memberof Twilio.Preview.DeployedDevices.FleetInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed FleetInstance
 */
/* jshint ignore:end */
FleetInstance.prototype.fetch = function fetch(callback) {
  return this._proxy.fetch(callback);
};

/* jshint ignore:start */
/**
 * remove a FleetInstance
 *
 * @function remove
 * @memberof Twilio.Preview.DeployedDevices.FleetInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed FleetInstance
 */
/* jshint ignore:end */
FleetInstance.prototype.remove = function remove(callback) {
  return this._proxy.remove(callback);
};

/* jshint ignore:start */
/**
 * update a FleetInstance
 *
 * @function update
 * @memberof Twilio.Preview.DeployedDevices.FleetInstance#
 *
 * @param {object} [opts] - Options for request
 * @param {string} [opts.friendlyName] -
 *          A human readable description for this Fleet.
 * @param {string} [opts.defaultDeploymentSid] - A default Deployment SID.
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed FleetInstance
 */
/* jshint ignore:end */
FleetInstance.prototype.update = function update(opts, callback) {
  return this._proxy.update(opts, callback);
};

/* jshint ignore:start */
/**
 * Access the devices
 *
 * @function devices
 * @memberof Twilio.Preview.DeployedDevices.FleetInstance#
 *
 * @returns {Twilio.Preview.DeployedDevices.FleetContext.DeviceList}
 */
/* jshint ignore:end */
FleetInstance.prototype.devices = function devices() {
  return this._proxy.devices;
};

/* jshint ignore:start */
/**
 * Access the deployments
 *
 * @function deployments
 * @memberof Twilio.Preview.DeployedDevices.FleetInstance#
 *
 * @returns {Twilio.Preview.DeployedDevices.FleetContext.DeploymentList}
 */
/* jshint ignore:end */
FleetInstance.prototype.deployments = function deployments() {
  return this._proxy.deployments;
};

/* jshint ignore:start */
/**
 * Access the certificates
 *
 * @function certificates
 * @memberof Twilio.Preview.DeployedDevices.FleetInstance#
 *
 * @returns {Twilio.Preview.DeployedDevices.FleetContext.CertificateList}
 */
/* jshint ignore:end */
FleetInstance.prototype.certificates = function certificates() {
  return this._proxy.certificates;
};

/* jshint ignore:start */
/**
 * Access the keys
 *
 * @function keys
 * @memberof Twilio.Preview.DeployedDevices.FleetInstance#
 *
 * @returns {Twilio.Preview.DeployedDevices.FleetContext.KeyList}
 */
/* jshint ignore:end */
FleetInstance.prototype.keys = function keys() {
  return this._proxy.keys;
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Preview.DeployedDevices.FleetInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
FleetInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

FleetInstance.prototype[util.inspect.custom] = function inspect(depth, options)
    {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the FleetContext
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Preview.DeployedDevices.FleetContext
 *
 * @property {Twilio.Preview.DeployedDevices.FleetContext.DeviceList} devices -
 *          devices resource
 * @property {Twilio.Preview.DeployedDevices.FleetContext.DeploymentList} deployments -
 *          deployments resource
 * @property {Twilio.Preview.DeployedDevices.FleetContext.CertificateList} certificates -
 *          certificates resource
 * @property {Twilio.Preview.DeployedDevices.FleetContext.KeyList} keys -
 *          keys resource
 *
 * @param {DeployedDevices} version - Version of the resource
 * @param {sid_like} sid - A string that uniquely identifies the Fleet.
 */
/* jshint ignore:end */
FleetContext = function FleetContext(version, sid) {
  this._version = version;

  // Path Solution
  this._solution = {sid: sid, };
  this._uri = `/Fleets/${sid}`;

  // Dependents
  this._devices = undefined;
  this._deployments = undefined;
  this._certificates = undefined;
  this._keys = undefined;
};

/* jshint ignore:start */
/**
 * fetch a FleetInstance
 *
 * @function fetch
 * @memberof Twilio.Preview.DeployedDevices.FleetContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed FleetInstance
 */
/* jshint ignore:end */
FleetContext.prototype.fetch = function fetch(callback) {
  var deferred = Q.defer();
  var promise = this._version.fetch({uri: this._uri, method: 'GET'});

  promise = promise.then(function(payload) {
    deferred.resolve(new FleetInstance(this._version, payload, this._solution.sid));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * remove a FleetInstance
 *
 * @function remove
 * @memberof Twilio.Preview.DeployedDevices.FleetContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed FleetInstance
 */
/* jshint ignore:end */
FleetContext.prototype.remove = function remove(callback) {
  var deferred = Q.defer();
  var promise = this._version.remove({uri: this._uri, method: 'DELETE'});

  promise = promise.then(function(payload) {
    deferred.resolve(payload);
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * update a FleetInstance
 *
 * @function update
 * @memberof Twilio.Preview.DeployedDevices.FleetContext#
 *
 * @param {object} [opts] - Options for request
 * @param {string} [opts.friendlyName] -
 *          A human readable description for this Fleet.
 * @param {string} [opts.defaultDeploymentSid] - A default Deployment SID.
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed FleetInstance
 */
/* jshint ignore:end */
FleetContext.prototype.update = function update(opts, callback) {
  if (_.isFunction(opts)) {
    callback = opts;
    opts = {};
  }
  opts = opts || {};

  var deferred = Q.defer();
  var data = values.of({
    'FriendlyName': _.get(opts, 'friendlyName'),
    'DefaultDeploymentSid': _.get(opts, 'defaultDeploymentSid')
  });

  var promise = this._version.update({uri: this._uri, method: 'POST', data: data});

  promise = promise.then(function(payload) {
    deferred.resolve(new FleetInstance(this._version, payload, this._solution.sid));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

Object.defineProperty(FleetContext.prototype,
  'devices', {
    get: function() {
      if (!this._devices) {
        this._devices = new DeviceList(this._version, this._solution.sid);
      }
      return this._devices;
    }
});

Object.defineProperty(FleetContext.prototype,
  'deployments', {
    get: function() {
      if (!this._deployments) {
        this._deployments = new DeploymentList(this._version, this._solution.sid);
      }
      return this._deployments;
    }
});

Object.defineProperty(FleetContext.prototype,
  'certificates', {
    get: function() {
      if (!this._certificates) {
        this._certificates = new CertificateList(this._version, this._solution.sid);
      }
      return this._certificates;
    }
});

Object.defineProperty(FleetContext.prototype,
  'keys', {
    get: function() {
      if (!this._keys) {
        this._keys = new KeyList(this._version, this._solution.sid);
      }
      return this._keys;
    }
});

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Preview.DeployedDevices.FleetContext#
 *
 * @returns Object
 */
/* jshint ignore:end */
FleetContext.prototype.toJSON = function toJSON() {
  return this._solution;
};

FleetContext.prototype[util.inspect.custom] = function inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  FleetList: FleetList,
  FleetPage: FleetPage,
  FleetInstance: FleetInstance,
  FleetContext: FleetContext
};
