'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var BindingList = require('./service/binding').BindingList;
var NotificationList = require('./service/notification').NotificationList;
var Page = require('../../../base/Page');  /* jshint ignore:line */
var deserialize = require(
    '../../../base/deserialize');  /* jshint ignore:line */
var serialize = require('../../../base/serialize');  /* jshint ignore:line */
var values = require('../../../base/values');  /* jshint ignore:line */

var ServiceList;
var ServicePage;
var ServiceInstance;
var ServiceContext;

/* jshint ignore:start */
/**
 * Initialize the ServiceList
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Notify.V1.ServiceList
 *
 * @param {Twilio.Notify.V1} version - Version of the resource
 */
/* jshint ignore:end */
ServiceList = function ServiceList(version) {
  /* jshint ignore:start */
  /**
   * @function services
   * @memberof Twilio.Notify.V1#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Notify.V1.ServiceContext}
   */
  /* jshint ignore:end */
  function ServiceListInstance(sid) {
    return ServiceListInstance.get(sid);
  }

  ServiceListInstance._version = version;
  // Path Solution
  ServiceListInstance._solution = {};
  ServiceListInstance._uri = `/Services`;
  /* jshint ignore:start */
  /**
   * create a ServiceInstance
   *
   * @function create
   * @memberof Twilio.Notify.V1.ServiceList#
   *
   * @param {object} [opts] - Options for request
   * @param {string} [opts.friendlyName] - A string to describe the resource
   * @param {string} [opts.apnCredentialSid] -
   *          The SID of the Credential to use for APN Bindings
   * @param {string} [opts.gcmCredentialSid] -
   *          The SID of the Credential to use for GCM Bindings
   * @param {string} [opts.messagingServiceSid] -
   *          The SID of the Messaging Service to use for SMS Bindings
   * @param {string} [opts.facebookMessengerPageId] - Deprecated
   * @param {string} [opts.defaultApnNotificationProtocolVersion] -
   *          The protocol version to use for sending APNS notifications
   * @param {string} [opts.defaultGcmNotificationProtocolVersion] -
   *          The protocol version to use for sending GCM notifications
   * @param {string} [opts.fcmCredentialSid] -
   *          The SID of the Credential to use for FCM Bindings
   * @param {string} [opts.defaultFcmNotificationProtocolVersion] -
   *          The protocol version to use for sending FCM notifications
   * @param {boolean} [opts.logEnabled] - Whether to log notifications
   * @param {string} [opts.alexaSkillId] - Deprecated
   * @param {string} [opts.defaultAlexaNotificationProtocolVersion] - Deprecated
   * @param {function} [callback] - Callback to handle processed record
   *
   * @returns {Promise} Resolves to processed ServiceInstance
   */
  /* jshint ignore:end */
  ServiceListInstance.create = function create(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};

    var deferred = Q.defer();
    var data = values.of({
      'FriendlyName': _.get(opts, 'friendlyName'),
      'ApnCredentialSid': _.get(opts, 'apnCredentialSid'),
      'GcmCredentialSid': _.get(opts, 'gcmCredentialSid'),
      'MessagingServiceSid': _.get(opts, 'messagingServiceSid'),
      'FacebookMessengerPageId': _.get(opts, 'facebookMessengerPageId'),
      'DefaultApnNotificationProtocolVersion': _.get(opts, 'defaultApnNotificationProtocolVersion'),
      'DefaultGcmNotificationProtocolVersion': _.get(opts, 'defaultGcmNotificationProtocolVersion'),
      'FcmCredentialSid': _.get(opts, 'fcmCredentialSid'),
      'DefaultFcmNotificationProtocolVersion': _.get(opts, 'defaultFcmNotificationProtocolVersion'),
      'LogEnabled': serialize.bool(_.get(opts, 'logEnabled')),
      'AlexaSkillId': _.get(opts, 'alexaSkillId'),
      'DefaultAlexaNotificationProtocolVersion': _.get(opts, 'defaultAlexaNotificationProtocolVersion')
    });

    var promise = this._version.create({uri: this._uri, method: 'POST', data: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new ServiceInstance(this._version, payload, this._solution.sid));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Streams ServiceInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function each
   * @memberof Twilio.Notify.V1.ServiceList#
   *
   * @param {object} [opts] - Options for request
   * @param {string} [opts.friendlyName] -
   *          The string that identifies the Service resources to read
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         each() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no pageSize is defined but a limit is defined,
   *         each() will attempt to read the limit with the most efficient
   *         page size, i.e. min(limit, 1000)
   * @param {Function} [opts.callback] -
   *         Function to process each record. If this and a positional
   *         callback are passed, this one will be used
   * @param {Function} [opts.done] -
   *          Function to be called upon completion of streaming
   * @param {Function} [callback] - Function to process each record
   */
  /* jshint ignore:end */
  ServiceListInstance.each = function each(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    if (opts.callback) {
      callback = opts.callback;
    }
    if (_.isUndefined(callback)) {
      throw new Error('Callback function must be provided');
    }

    var done = false;
    var currentPage = 1;
    var currentResource = 0;
    var limits = this._version.readLimits({
      limit: opts.limit,
      pageSize: opts.pageSize
    });

    function onComplete(error) {
      done = true;
      if (_.isFunction(opts.done)) {
        opts.done(error);
      }
    }

    function fetchNextPage(fn) {
      var promise = fn();
      if (_.isUndefined(promise)) {
        onComplete();
        return;
      }

      promise.then(function(page) {
        _.each(page.instances, function(instance) {
          if (done || (!_.isUndefined(opts.limit) && currentResource >= opts.limit)) {
            done = true;
            return false;
          }

          currentResource++;
          callback(instance, onComplete);
        });

        if ((limits.pageLimit && limits.pageLimit <= currentPage)) {
          onComplete();
        } else if (!done) {
          currentPage++;
          fetchNextPage(_.bind(page.nextPage, page));
        }
      });

      promise.catch(onComplete);
    }

    fetchNextPage(_.bind(this.page, this, _.merge(opts, limits)));
  };

  /* jshint ignore:start */
  /**
   * Lists ServiceInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function list
   * @memberof Twilio.Notify.V1.ServiceList#
   *
   * @param {object} [opts] - Options for request
   * @param {string} [opts.friendlyName] -
   *          The string that identifies the Service resources to read
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         list() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no page_size is defined but a limit is defined,
   *         list() will attempt to read the limit with the most
   *         efficient page size, i.e. min(limit, 1000)
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  ServiceListInstance.list = function list(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    var deferred = Q.defer();
    var allResources = [];
    opts.callback = function(resource, done) {
      allResources.push(resource);

      if (!_.isUndefined(opts.limit) && allResources.length === opts.limit) {
        done();
      }
    };

    opts.done = function(error) {
      if (_.isUndefined(error)) {
        deferred.resolve(allResources);
      } else {
        deferred.reject(error);
      }
    };

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    this.each(opts);
    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single page of ServiceInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function page
   * @memberof Twilio.Notify.V1.ServiceList#
   *
   * @param {object} [opts] - Options for request
   * @param {string} [opts.friendlyName] -
   *          The string that identifies the Service resources to read
   * @param {string} [opts.pageToken] - PageToken provided by the API
   * @param {number} [opts.pageNumber] -
   *          Page Number, this value is simply for client state
   * @param {number} [opts.pageSize] - Number of records to return, defaults to 50
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  ServiceListInstance.page = function page(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};

    var deferred = Q.defer();
    var data = values.of({
      'FriendlyName': _.get(opts, 'friendlyName'),
      'PageToken': opts.pageToken,
      'Page': opts.pageNumber,
      'PageSize': opts.pageSize
    });

    var promise = this._version.page({uri: this._uri, method: 'GET', params: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new ServicePage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single target page of ServiceInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function getPage
   * @memberof Twilio.Notify.V1.ServiceList#
   *
   * @param {string} [targetUrl] - API-generated URL for the requested results page
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  ServiceListInstance.getPage = function getPage(targetUrl, callback) {
    var deferred = Q.defer();

    var promise = this._version._domain.twilio.request({method: 'GET', uri: targetUrl});

    promise = promise.then(function(payload) {
      deferred.resolve(new ServicePage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Constructs a service
   *
   * @function get
   * @memberof Twilio.Notify.V1.ServiceList#
   *
   * @param {string} sid - The unique string that identifies the resource
   *
   * @returns {Twilio.Notify.V1.ServiceContext}
   */
  /* jshint ignore:end */
  ServiceListInstance.get = function get(sid) {
    return new ServiceContext(this._version, sid);
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Notify.V1.ServiceList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  ServiceListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  ServiceListInstance[util.inspect.custom] = function inspect(depth, options) {
    return util.inspect(this.toJSON(), options);
  };

  return ServiceListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the ServicePage
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Notify.V1.ServicePage
 *
 * @param {V1} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {ServiceSolution} solution - Path solution
 *
 * @returns ServicePage
 */
/* jshint ignore:end */
ServicePage = function ServicePage(version, response, solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(ServicePage.prototype, Page.prototype);
ServicePage.prototype.constructor = ServicePage;

/* jshint ignore:start */
/**
 * Build an instance of ServiceInstance
 *
 * @function getInstance
 * @memberof Twilio.Notify.V1.ServicePage#
 *
 * @param {ServicePayload} payload - Payload response from the API
 *
 * @returns ServiceInstance
 */
/* jshint ignore:end */
ServicePage.prototype.getInstance = function getInstance(payload) {
  return new ServiceInstance(this._version, payload);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Notify.V1.ServicePage#
 *
 * @returns Object
 */
/* jshint ignore:end */
ServicePage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

ServicePage.prototype[util.inspect.custom] = function inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the ServiceContext
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Notify.V1.ServiceInstance
 *
 * @property {string} sid - The unique string that identifies the resource
 * @property {string} accountSid - The SID of the Account that created the resource
 * @property {string} friendlyName -
 *          The string that you assigned to describe the resource
 * @property {Date} dateCreated -
 *          The RFC 2822 date and time in GMT when the resource was created
 * @property {Date} dateUpdated -
 *          The RFC 2822 date and time in GMT when the resource was last updated
 * @property {string} apnCredentialSid -
 *          The SID of the Credential to use for APN Bindings
 * @property {string} gcmCredentialSid -
 *          The SID of the Credential to use for GCM Bindings
 * @property {string} fcmCredentialSid -
 *          The SID of the Credential to use for FCM Bindings
 * @property {string} messagingServiceSid -
 *          The SID of the Messaging Service to use for SMS Bindings
 * @property {string} facebookMessengerPageId - Deprecated
 * @property {string} defaultApnNotificationProtocolVersion -
 *          The protocol version to use for sending APNS notifications
 * @property {string} defaultGcmNotificationProtocolVersion -
 *          The protocol version to use for sending GCM notifications
 * @property {string} defaultFcmNotificationProtocolVersion -
 *          The protocol version to use for sending FCM notifications
 * @property {boolean} logEnabled - Whether to log notifications
 * @property {string} url - The absolute URL of the Service resource
 * @property {string} links - The URLs of the resources related to the service
 * @property {string} alexaSkillId - Deprecated
 * @property {string} defaultAlexaNotificationProtocolVersion - Deprecated
 *
 * @param {V1} version - Version of the resource
 * @param {ServicePayload} payload - The instance payload
 * @param {sid} sid - The unique string that identifies the resource
 */
/* jshint ignore:end */
ServiceInstance = function ServiceInstance(version, payload, sid) {
  this._version = version;

  // Marshaled Properties
  this.sid = payload.sid; // jshint ignore:line
  this.accountSid = payload.account_sid; // jshint ignore:line
  this.friendlyName = payload.friendly_name; // jshint ignore:line
  this.dateCreated = deserialize.iso8601DateTime(payload.date_created); // jshint ignore:line
  this.dateUpdated = deserialize.iso8601DateTime(payload.date_updated); // jshint ignore:line
  this.apnCredentialSid = payload.apn_credential_sid; // jshint ignore:line
  this.gcmCredentialSid = payload.gcm_credential_sid; // jshint ignore:line
  this.fcmCredentialSid = payload.fcm_credential_sid; // jshint ignore:line
  this.messagingServiceSid = payload.messaging_service_sid; // jshint ignore:line
  this.facebookMessengerPageId = payload.facebook_messenger_page_id; // jshint ignore:line
  this.defaultApnNotificationProtocolVersion = payload.default_apn_notification_protocol_version; // jshint ignore:line
  this.defaultGcmNotificationProtocolVersion = payload.default_gcm_notification_protocol_version; // jshint ignore:line
  this.defaultFcmNotificationProtocolVersion = payload.default_fcm_notification_protocol_version; // jshint ignore:line
  this.logEnabled = payload.log_enabled; // jshint ignore:line
  this.url = payload.url; // jshint ignore:line
  this.links = payload.links; // jshint ignore:line
  this.alexaSkillId = payload.alexa_skill_id; // jshint ignore:line
  this.defaultAlexaNotificationProtocolVersion = payload.default_alexa_notification_protocol_version; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {sid: sid || this.sid, };
};

Object.defineProperty(ServiceInstance.prototype,
  '_proxy', {
    get: function() {
      if (!this._context) {
        this._context = new ServiceContext(this._version, this._solution.sid);
      }

      return this._context;
    }
});

/* jshint ignore:start */
/**
 * remove a ServiceInstance
 *
 * @function remove
 * @memberof Twilio.Notify.V1.ServiceInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed ServiceInstance
 */
/* jshint ignore:end */
ServiceInstance.prototype.remove = function remove(callback) {
  return this._proxy.remove(callback);
};

/* jshint ignore:start */
/**
 * fetch a ServiceInstance
 *
 * @function fetch
 * @memberof Twilio.Notify.V1.ServiceInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed ServiceInstance
 */
/* jshint ignore:end */
ServiceInstance.prototype.fetch = function fetch(callback) {
  return this._proxy.fetch(callback);
};

/* jshint ignore:start */
/**
 * update a ServiceInstance
 *
 * @function update
 * @memberof Twilio.Notify.V1.ServiceInstance#
 *
 * @param {object} [opts] - Options for request
 * @param {string} [opts.friendlyName] - A string to describe the resource
 * @param {string} [opts.apnCredentialSid] -
 *          The SID of the Credential to use for APN Bindings
 * @param {string} [opts.gcmCredentialSid] -
 *          The SID of the Credential to use for GCM Bindings
 * @param {string} [opts.messagingServiceSid] -
 *          The SID of the Messaging Service to use for SMS Bindings
 * @param {string} [opts.facebookMessengerPageId] - Deprecated
 * @param {string} [opts.defaultApnNotificationProtocolVersion] -
 *          The protocol version to use for sending APNS notifications
 * @param {string} [opts.defaultGcmNotificationProtocolVersion] -
 *          The protocol version to use for sending GCM notifications
 * @param {string} [opts.fcmCredentialSid] -
 *          The SID of the Credential to use for FCM Bindings
 * @param {string} [opts.defaultFcmNotificationProtocolVersion] -
 *          The protocol version to use for sending FCM notifications
 * @param {boolean} [opts.logEnabled] - Whether to log notifications
 * @param {string} [opts.alexaSkillId] - Deprecated
 * @param {string} [opts.defaultAlexaNotificationProtocolVersion] - Deprecated
 * @param {string} [opts.deliveryCallbackUrl] - Webhook URL
 * @param {boolean} [opts.deliveryCallbackEnabled] - Enable delivery callbacks
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed ServiceInstance
 */
/* jshint ignore:end */
ServiceInstance.prototype.update = function update(opts, callback) {
  return this._proxy.update(opts, callback);
};

/* jshint ignore:start */
/**
 * Access the bindings
 *
 * @function bindings
 * @memberof Twilio.Notify.V1.ServiceInstance#
 *
 * @returns {Twilio.Notify.V1.ServiceContext.BindingList}
 */
/* jshint ignore:end */
ServiceInstance.prototype.bindings = function bindings() {
  return this._proxy.bindings;
};

/* jshint ignore:start */
/**
 * Access the notifications
 *
 * @function notifications
 * @memberof Twilio.Notify.V1.ServiceInstance#
 *
 * @returns {Twilio.Notify.V1.ServiceContext.NotificationList}
 */
/* jshint ignore:end */
ServiceInstance.prototype.notifications = function notifications() {
  return this._proxy.notifications;
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Notify.V1.ServiceInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
ServiceInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

ServiceInstance.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the ServiceContext
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Notify.V1.ServiceContext
 *
 * @property {Twilio.Notify.V1.ServiceContext.BindingList} bindings -
 *          bindings resource
 * @property {Twilio.Notify.V1.ServiceContext.NotificationList} notifications -
 *          notifications resource
 *
 * @param {V1} version - Version of the resource
 * @param {sid} sid - The unique string that identifies the resource
 */
/* jshint ignore:end */
ServiceContext = function ServiceContext(version, sid) {
  this._version = version;

  // Path Solution
  this._solution = {sid: sid, };
  this._uri = `/Services/${sid}`;

  // Dependents
  this._bindings = undefined;
  this._notifications = undefined;
};

/* jshint ignore:start */
/**
 * remove a ServiceInstance
 *
 * @function remove
 * @memberof Twilio.Notify.V1.ServiceContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed ServiceInstance
 */
/* jshint ignore:end */
ServiceContext.prototype.remove = function remove(callback) {
  var deferred = Q.defer();
  var promise = this._version.remove({uri: this._uri, method: 'DELETE'});

  promise = promise.then(function(payload) {
    deferred.resolve(payload);
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * fetch a ServiceInstance
 *
 * @function fetch
 * @memberof Twilio.Notify.V1.ServiceContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed ServiceInstance
 */
/* jshint ignore:end */
ServiceContext.prototype.fetch = function fetch(callback) {
  var deferred = Q.defer();
  var promise = this._version.fetch({uri: this._uri, method: 'GET'});

  promise = promise.then(function(payload) {
    deferred.resolve(new ServiceInstance(this._version, payload, this._solution.sid));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * update a ServiceInstance
 *
 * @function update
 * @memberof Twilio.Notify.V1.ServiceContext#
 *
 * @param {object} [opts] - Options for request
 * @param {string} [opts.friendlyName] - A string to describe the resource
 * @param {string} [opts.apnCredentialSid] -
 *          The SID of the Credential to use for APN Bindings
 * @param {string} [opts.gcmCredentialSid] -
 *          The SID of the Credential to use for GCM Bindings
 * @param {string} [opts.messagingServiceSid] -
 *          The SID of the Messaging Service to use for SMS Bindings
 * @param {string} [opts.facebookMessengerPageId] - Deprecated
 * @param {string} [opts.defaultApnNotificationProtocolVersion] -
 *          The protocol version to use for sending APNS notifications
 * @param {string} [opts.defaultGcmNotificationProtocolVersion] -
 *          The protocol version to use for sending GCM notifications
 * @param {string} [opts.fcmCredentialSid] -
 *          The SID of the Credential to use for FCM Bindings
 * @param {string} [opts.defaultFcmNotificationProtocolVersion] -
 *          The protocol version to use for sending FCM notifications
 * @param {boolean} [opts.logEnabled] - Whether to log notifications
 * @param {string} [opts.alexaSkillId] - Deprecated
 * @param {string} [opts.defaultAlexaNotificationProtocolVersion] - Deprecated
 * @param {string} [opts.deliveryCallbackUrl] - Webhook URL
 * @param {boolean} [opts.deliveryCallbackEnabled] - Enable delivery callbacks
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed ServiceInstance
 */
/* jshint ignore:end */
ServiceContext.prototype.update = function update(opts, callback) {
  if (_.isFunction(opts)) {
    callback = opts;
    opts = {};
  }
  opts = opts || {};

  var deferred = Q.defer();
  var data = values.of({
    'FriendlyName': _.get(opts, 'friendlyName'),
    'ApnCredentialSid': _.get(opts, 'apnCredentialSid'),
    'GcmCredentialSid': _.get(opts, 'gcmCredentialSid'),
    'MessagingServiceSid': _.get(opts, 'messagingServiceSid'),
    'FacebookMessengerPageId': _.get(opts, 'facebookMessengerPageId'),
    'DefaultApnNotificationProtocolVersion': _.get(opts, 'defaultApnNotificationProtocolVersion'),
    'DefaultGcmNotificationProtocolVersion': _.get(opts, 'defaultGcmNotificationProtocolVersion'),
    'FcmCredentialSid': _.get(opts, 'fcmCredentialSid'),
    'DefaultFcmNotificationProtocolVersion': _.get(opts, 'defaultFcmNotificationProtocolVersion'),
    'LogEnabled': serialize.bool(_.get(opts, 'logEnabled')),
    'AlexaSkillId': _.get(opts, 'alexaSkillId'),
    'DefaultAlexaNotificationProtocolVersion': _.get(opts, 'defaultAlexaNotificationProtocolVersion'),
    'DeliveryCallbackUrl': _.get(opts, 'deliveryCallbackUrl'),
    'DeliveryCallbackEnabled': serialize.bool(_.get(opts, 'deliveryCallbackEnabled'))
  });

  var promise = this._version.update({uri: this._uri, method: 'POST', data: data});

  promise = promise.then(function(payload) {
    deferred.resolve(new ServiceInstance(this._version, payload, this._solution.sid));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

Object.defineProperty(ServiceContext.prototype,
  'bindings', {
    get: function() {
      if (!this._bindings) {
        this._bindings = new BindingList(this._version, this._solution.sid);
      }
      return this._bindings;
    }
});

Object.defineProperty(ServiceContext.prototype,
  'notifications', {
    get: function() {
      if (!this._notifications) {
        this._notifications = new NotificationList(this._version, this._solution.sid);
      }
      return this._notifications;
    }
});

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Notify.V1.ServiceContext#
 *
 * @returns Object
 */
/* jshint ignore:end */
ServiceContext.prototype.toJSON = function toJSON() {
  return this._solution;
};

ServiceContext.prototype[util.inspect.custom] = function inspect(depth, options)
    {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  ServiceList: ServiceList,
  ServicePage: ServicePage,
  ServiceInstance: ServiceInstance,
  ServiceContext: ServiceContext
};
