/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../base/Page');
import Response = require('../../../http/response');
import V1 = require('../V1');
import serialize = require('../../../base/serialize');
import { SerializableClass } from '../../../interfaces';

/**
 * Initialize the EventList
 *
 * @param version - Version of the resource
 */
declare function EventList(version: V1): EventListInstance;

interface EventListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): EventContext;
  /**
   * Streams EventInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Function to process each record
   */
  each(opts?: EventListInstanceEachOptions, callback?: (item: EventInstance, done: (err?: Error) => void) => void): void;
  /**
   * Constructs a event
   *
   * @param sid - The SID that identifies the resource to fetch
   */
  get(sid: string): EventContext;
  /**
   * Retrieve a single target page of EventInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param targetUrl - API-generated URL for the requested results page
   * @param callback - Callback to handle list of records
   */
  getPage(targetUrl?: string, callback?: (error: Error | null, items: EventPage) => any): Promise<EventPage>;
  /**
   * Lists EventInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  list(opts?: EventListInstanceOptions, callback?: (error: Error | null, items: EventInstance[]) => any): Promise<EventInstance[]>;
  /**
   * Retrieve a single page of EventInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  page(opts?: EventListInstancePageOptions, callback?: (error: Error | null, items: EventPage) => any): Promise<EventPage>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to each
 *
 * @property actorSid - Only include events initiated by this Actor
 * @property callback -
 *                         Function to process each record. If this and a positional
 *                         callback are passed, this one will be used
 * @property done - Function to be called upon completion of streaming
 * @property endDate - Only include events that occurred on or before this date
 * @property eventType - Only include events of this Event Type
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         each() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no pageSize is defined but a limit is defined,
 *                         each() will attempt to read the limit with the most efficient
 *                         page size, i.e. min(limit, 1000)
 * @property resourceSid - Only include events that refer to this resource
 * @property sourceIpAddress - Only include events that originated from this IP address
 * @property startDate - Only include events that occurred on or after this date
 */
interface EventListInstanceEachOptions {
  actorSid?: string;
  callback?: (item: EventInstance, done: (err?: Error) => void) => void;
  done?: Function;
  endDate?: Date;
  eventType?: string;
  limit?: number;
  pageSize?: number;
  resourceSid?: string;
  sourceIpAddress?: string;
  startDate?: Date;
}

/**
 * Options to pass to list
 *
 * @property actorSid - Only include events initiated by this Actor
 * @property endDate - Only include events that occurred on or before this date
 * @property eventType - Only include events of this Event Type
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         list() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no page_size is defined but a limit is defined,
 *                         list() will attempt to read the limit with the most
 *                         efficient page size, i.e. min(limit, 1000)
 * @property resourceSid - Only include events that refer to this resource
 * @property sourceIpAddress - Only include events that originated from this IP address
 * @property startDate - Only include events that occurred on or after this date
 */
interface EventListInstanceOptions {
  actorSid?: string;
  endDate?: Date;
  eventType?: string;
  limit?: number;
  pageSize?: number;
  resourceSid?: string;
  sourceIpAddress?: string;
  startDate?: Date;
}

/**
 * Options to pass to page
 *
 * @property actorSid - Only include events initiated by this Actor
 * @property endDate - Only include events that occurred on or before this date
 * @property eventType - Only include events of this Event Type
 * @property pageNumber - Page Number, this value is simply for client state
 * @property pageSize - Number of records to return, defaults to 50
 * @property pageToken - PageToken provided by the API
 * @property resourceSid - Only include events that refer to this resource
 * @property sourceIpAddress - Only include events that originated from this IP address
 * @property startDate - Only include events that occurred on or after this date
 */
interface EventListInstancePageOptions {
  actorSid?: string;
  endDate?: Date;
  eventType?: string;
  pageNumber?: number;
  pageSize?: number;
  pageToken?: string;
  resourceSid?: string;
  sourceIpAddress?: string;
  startDate?: Date;
}

interface EventPayload extends EventResource, Page.TwilioResponsePayload {
}

interface EventResource {
  account_sid: string;
  actor_sid: string;
  actor_type: string;
  description: string;
  event_data: object;
  event_date: Date;
  event_type: string;
  links: string;
  resource_sid: string;
  resource_type: string;
  sid: string;
  source: string;
  source_ip_address: string;
  url: string;
}

interface EventSolution {
}


declare class EventContext {
  /**
   * Initialize the EventContext
   *
   * @param version - Version of the resource
   * @param sid - The SID that identifies the resource to fetch
   */
  constructor(version: V1, sid: string);

  /**
   * fetch a EventInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: EventInstance) => any): Promise<EventInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class EventInstance extends SerializableClass {
  /**
   * Initialize the EventContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param sid - The SID that identifies the resource to fetch
   */
  constructor(version: V1, payload: EventPayload, sid: string);

  private _proxy: EventContext;
  accountSid: string;
  actorSid: string;
  actorType: string;
  description: string;
  eventData: object;
  eventDate: Date;
  eventType: string;
  /**
   * fetch a EventInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: EventInstance) => any): Promise<EventInstance>;
  links: string;
  resourceSid: string;
  resourceType: string;
  sid: string;
  source: string;
  sourceIpAddress: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  url: string;
}


declare class EventPage extends Page<V1, EventPayload, EventResource, EventInstance> {
  /**
   * Initialize the EventPage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: EventSolution);

  /**
   * Build an instance of EventInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: EventPayload): EventInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { EventContext, EventInstance, EventList, EventListInstance, EventListInstanceEachOptions, EventListInstanceOptions, EventListInstancePageOptions, EventPage, EventPayload, EventResource, EventSolution }
