'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var Page = require('../../../base/Page');  /* jshint ignore:line */
var deserialize = require(
    '../../../base/deserialize');  /* jshint ignore:line */
var serialize = require('../../../base/serialize');  /* jshint ignore:line */
var values = require('../../../base/values');  /* jshint ignore:line */

var AlertList;
var AlertPage;
var AlertInstance;
var AlertContext;

/* jshint ignore:start */
/**
 * Initialize the AlertList
 *
 * @constructor Twilio.Monitor.V1.AlertList
 *
 * @param {Twilio.Monitor.V1} version - Version of the resource
 */
/* jshint ignore:end */
AlertList = function AlertList(version) {
  /* jshint ignore:start */
  /**
   * @function alerts
   * @memberof Twilio.Monitor.V1#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Monitor.V1.AlertContext}
   */
  /* jshint ignore:end */
  function AlertListInstance(sid) {
    return AlertListInstance.get(sid);
  }

  AlertListInstance._version = version;
  // Path Solution
  AlertListInstance._solution = {};
  AlertListInstance._uri = `/Alerts`;
  /* jshint ignore:start */
  /**
   * Streams AlertInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function each
   * @memberof Twilio.Monitor.V1.AlertList#
   *
   * @param {object} [opts] - Options for request
   * @param {string} [opts.logLevel] - Only show alerts for this log-level
   * @param {Date} [opts.startDate] -
   *          Only include alerts that occurred on or after this date and time
   * @param {Date} [opts.endDate] -
   *          Only include alerts that occurred on or before this date and time
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         each() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no pageSize is defined but a limit is defined,
   *         each() will attempt to read the limit with the most efficient
   *         page size, i.e. min(limit, 1000)
   * @param {Function} [opts.callback] -
   *         Function to process each record. If this and a positional
   *         callback are passed, this one will be used
   * @param {Function} [opts.done] -
   *          Function to be called upon completion of streaming
   * @param {Function} [callback] - Function to process each record
   */
  /* jshint ignore:end */
  AlertListInstance.each = function each(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    if (opts.callback) {
      callback = opts.callback;
    }
    if (_.isUndefined(callback)) {
      throw new Error('Callback function must be provided');
    }

    var done = false;
    var currentPage = 1;
    var currentResource = 0;
    var limits = this._version.readLimits({
      limit: opts.limit,
      pageSize: opts.pageSize
    });

    function onComplete(error) {
      done = true;
      if (_.isFunction(opts.done)) {
        opts.done(error);
      }
    }

    function fetchNextPage(fn) {
      var promise = fn();
      if (_.isUndefined(promise)) {
        onComplete();
        return;
      }

      promise.then(function(page) {
        _.each(page.instances, function(instance) {
          if (done || (!_.isUndefined(opts.limit) && currentResource >= opts.limit)) {
            done = true;
            return false;
          }

          currentResource++;
          callback(instance, onComplete);
        });

        if ((limits.pageLimit && limits.pageLimit <= currentPage)) {
          onComplete();
        } else if (!done) {
          currentPage++;
          fetchNextPage(_.bind(page.nextPage, page));
        }
      });

      promise.catch(onComplete);
    }

    fetchNextPage(_.bind(this.page, this, _.merge(opts, limits)));
  };

  /* jshint ignore:start */
  /**
   * Lists AlertInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function list
   * @memberof Twilio.Monitor.V1.AlertList#
   *
   * @param {object} [opts] - Options for request
   * @param {string} [opts.logLevel] - Only show alerts for this log-level
   * @param {Date} [opts.startDate] -
   *          Only include alerts that occurred on or after this date and time
   * @param {Date} [opts.endDate] -
   *          Only include alerts that occurred on or before this date and time
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         list() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no page_size is defined but a limit is defined,
   *         list() will attempt to read the limit with the most
   *         efficient page size, i.e. min(limit, 1000)
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  AlertListInstance.list = function list(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    var deferred = Q.defer();
    var allResources = [];
    opts.callback = function(resource, done) {
      allResources.push(resource);

      if (!_.isUndefined(opts.limit) && allResources.length === opts.limit) {
        done();
      }
    };

    opts.done = function(error) {
      if (_.isUndefined(error)) {
        deferred.resolve(allResources);
      } else {
        deferred.reject(error);
      }
    };

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    this.each(opts);
    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single page of AlertInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function page
   * @memberof Twilio.Monitor.V1.AlertList#
   *
   * @param {object} [opts] - Options for request
   * @param {string} [opts.logLevel] - Only show alerts for this log-level
   * @param {Date} [opts.startDate] -
   *          Only include alerts that occurred on or after this date and time
   * @param {Date} [opts.endDate] -
   *          Only include alerts that occurred on or before this date and time
   * @param {string} [opts.pageToken] - PageToken provided by the API
   * @param {number} [opts.pageNumber] -
   *          Page Number, this value is simply for client state
   * @param {number} [opts.pageSize] - Number of records to return, defaults to 50
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  AlertListInstance.page = function page(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};

    var deferred = Q.defer();
    var data = values.of({
      'LogLevel': _.get(opts, 'logLevel'),
      'StartDate': serialize.iso8601Date(_.get(opts, 'startDate')),
      'EndDate': serialize.iso8601Date(_.get(opts, 'endDate')),
      'PageToken': opts.pageToken,
      'Page': opts.pageNumber,
      'PageSize': opts.pageSize
    });

    var promise = this._version.page({uri: this._uri, method: 'GET', params: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new AlertPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single target page of AlertInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function getPage
   * @memberof Twilio.Monitor.V1.AlertList#
   *
   * @param {string} [targetUrl] - API-generated URL for the requested results page
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  AlertListInstance.getPage = function getPage(targetUrl, callback) {
    var deferred = Q.defer();

    var promise = this._version._domain.twilio.request({method: 'GET', uri: targetUrl});

    promise = promise.then(function(payload) {
      deferred.resolve(new AlertPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Constructs a alert
   *
   * @function get
   * @memberof Twilio.Monitor.V1.AlertList#
   *
   * @param {string} sid - The SID that identifies the resource to fetch
   *
   * @returns {Twilio.Monitor.V1.AlertContext}
   */
  /* jshint ignore:end */
  AlertListInstance.get = function get(sid) {
    return new AlertContext(this._version, sid);
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Monitor.V1.AlertList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  AlertListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  AlertListInstance[util.inspect.custom] = function inspect(depth, options) {
    return util.inspect(this.toJSON(), options);
  };

  return AlertListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the AlertPage
 *
 * @constructor Twilio.Monitor.V1.AlertPage
 *
 * @param {V1} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {AlertSolution} solution - Path solution
 *
 * @returns AlertPage
 */
/* jshint ignore:end */
AlertPage = function AlertPage(version, response, solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(AlertPage.prototype, Page.prototype);
AlertPage.prototype.constructor = AlertPage;

/* jshint ignore:start */
/**
 * Build an instance of AlertInstance
 *
 * @function getInstance
 * @memberof Twilio.Monitor.V1.AlertPage#
 *
 * @param {AlertPayload} payload - Payload response from the API
 *
 * @returns AlertInstance
 */
/* jshint ignore:end */
AlertPage.prototype.getInstance = function getInstance(payload) {
  return new AlertInstance(this._version, payload);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Monitor.V1.AlertPage#
 *
 * @returns Object
 */
/* jshint ignore:end */
AlertPage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

AlertPage.prototype[util.inspect.custom] = function inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the AlertContext
 *
 * @constructor Twilio.Monitor.V1.AlertInstance
 *
 * @property {string} accountSid - The SID of the Account that created the resource
 * @property {string} alertText - The text of the alert
 * @property {string} apiVersion -
 *          The API version used when the alert was generated
 * @property {Date} dateCreated -
 *          The ISO 8601 date and time in GMT when the resource was created
 * @property {Date} dateGenerated -
 *          The date and time when the alert was generated specified in ISO 8601 format
 * @property {Date} dateUpdated -
 *          The ISO 8601 date and time in GMT when the resource was last updated
 * @property {string} errorCode -
 *          The error code for the condition that generated the alert
 * @property {string} logLevel - The log level
 * @property {string} moreInfo -
 *          The URL of the page in our Error Dictionary with more information about the error condition
 * @property {string} requestMethod -
 *          The method used by the request that generated the alert
 * @property {string} requestUrl - The URL of the request that generated the alert
 * @property {string} requestVariables -
 *          The variables passed in the request that generated the alert
 * @property {string} resourceSid -
 *          The SID of the resource for which the alert was generated
 * @property {string} responseBody -
 *          The response body of the request that generated the alert
 * @property {string} responseHeaders -
 *          The response headers of the request that generated the alert
 * @property {string} sid - The unique string that identifies the resource
 * @property {string} url - The absolute URL of the Alert resource
 * @property {string} requestHeaders -
 *          The request headers of the request that generated the alert
 * @property {string} serviceSid -
 *          The SID of the service or resource that generated the alert
 *
 * @param {V1} version - Version of the resource
 * @param {AlertPayload} payload - The instance payload
 * @param {sid} sid - The SID that identifies the resource to fetch
 */
/* jshint ignore:end */
AlertInstance = function AlertInstance(version, payload, sid) {
  this._version = version;

  // Marshaled Properties
  this.accountSid = payload.account_sid; // jshint ignore:line
  this.alertText = payload.alert_text; // jshint ignore:line
  this.apiVersion = payload.api_version; // jshint ignore:line
  this.dateCreated = deserialize.iso8601DateTime(payload.date_created); // jshint ignore:line
  this.dateGenerated = deserialize.iso8601DateTime(payload.date_generated); // jshint ignore:line
  this.dateUpdated = deserialize.iso8601DateTime(payload.date_updated); // jshint ignore:line
  this.errorCode = payload.error_code; // jshint ignore:line
  this.logLevel = payload.log_level; // jshint ignore:line
  this.moreInfo = payload.more_info; // jshint ignore:line
  this.requestMethod = payload.request_method; // jshint ignore:line
  this.requestUrl = payload.request_url; // jshint ignore:line
  this.requestVariables = payload.request_variables; // jshint ignore:line
  this.resourceSid = payload.resource_sid; // jshint ignore:line
  this.responseBody = payload.response_body; // jshint ignore:line
  this.responseHeaders = payload.response_headers; // jshint ignore:line
  this.sid = payload.sid; // jshint ignore:line
  this.url = payload.url; // jshint ignore:line
  this.requestHeaders = payload.request_headers; // jshint ignore:line
  this.serviceSid = payload.service_sid; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {sid: sid || this.sid, };
};

Object.defineProperty(AlertInstance.prototype,
  '_proxy', {
    get: function() {
      if (!this._context) {
        this._context = new AlertContext(this._version, this._solution.sid);
      }

      return this._context;
    }
});

/* jshint ignore:start */
/**
 * fetch a AlertInstance
 *
 * @function fetch
 * @memberof Twilio.Monitor.V1.AlertInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed AlertInstance
 */
/* jshint ignore:end */
AlertInstance.prototype.fetch = function fetch(callback) {
  return this._proxy.fetch(callback);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Monitor.V1.AlertInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
AlertInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

AlertInstance.prototype[util.inspect.custom] = function inspect(depth, options)
    {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the AlertContext
 *
 * @constructor Twilio.Monitor.V1.AlertContext
 *
 * @param {V1} version - Version of the resource
 * @param {sid} sid - The SID that identifies the resource to fetch
 */
/* jshint ignore:end */
AlertContext = function AlertContext(version, sid) {
  this._version = version;

  // Path Solution
  this._solution = {sid: sid, };
  this._uri = `/Alerts/${sid}`;
};

/* jshint ignore:start */
/**
 * fetch a AlertInstance
 *
 * @function fetch
 * @memberof Twilio.Monitor.V1.AlertContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed AlertInstance
 */
/* jshint ignore:end */
AlertContext.prototype.fetch = function fetch(callback) {
  var deferred = Q.defer();
  var promise = this._version.fetch({uri: this._uri, method: 'GET'});

  promise = promise.then(function(payload) {
    deferred.resolve(new AlertInstance(this._version, payload, this._solution.sid));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Monitor.V1.AlertContext#
 *
 * @returns Object
 */
/* jshint ignore:end */
AlertContext.prototype.toJSON = function toJSON() {
  return this._solution;
};

AlertContext.prototype[util.inspect.custom] = function inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  AlertList: AlertList,
  AlertPage: AlertPage,
  AlertInstance: AlertInstance,
  AlertContext: AlertContext
};
