/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../../base/Page');
import Response = require('../../../../http/response');
import V1 = require('../../V1');
import { SerializableClass } from '../../../../interfaces';

type ModelBuildStatus = 'enqueued'|'building'|'completed'|'failed'|'canceled';

/**
 * Initialize the ModelBuildList
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @param version - Version of the resource
 * @param assistantSid - The SID of the Assistant that is the parent of the resource
 */
declare function ModelBuildList(version: V1, assistantSid: string): ModelBuildListInstance;

/**
 * Options to pass to update
 *
 * @property uniqueName - An application-defined string that uniquely identifies the resource
 */
interface ModelBuildInstanceUpdateOptions {
  uniqueName?: string;
}

interface ModelBuildListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): ModelBuildContext;
  /**
   * create a ModelBuildInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  create(opts?: ModelBuildListInstanceCreateOptions, callback?: (error: Error | null, item: ModelBuildInstance) => any): Promise<ModelBuildInstance>;
  /**
   * Streams ModelBuildInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Function to process each record
   */
  each(opts?: ModelBuildListInstanceEachOptions, callback?: (item: ModelBuildInstance, done: (err?: Error) => void) => void): void;
  /**
   * Constructs a model_build
   *
   * @param sid - The unique string that identifies the resource
   */
  get(sid: string): ModelBuildContext;
  /**
   * Retrieve a single target page of ModelBuildInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param targetUrl - API-generated URL for the requested results page
   * @param callback - Callback to handle list of records
   */
  getPage(targetUrl?: string, callback?: (error: Error | null, items: ModelBuildPage) => any): Promise<ModelBuildPage>;
  /**
   * Lists ModelBuildInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  list(opts?: ModelBuildListInstanceOptions, callback?: (error: Error | null, items: ModelBuildInstance[]) => any): Promise<ModelBuildInstance[]>;
  /**
   * Retrieve a single page of ModelBuildInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  page(opts?: ModelBuildListInstancePageOptions, callback?: (error: Error | null, items: ModelBuildPage) => any): Promise<ModelBuildPage>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to create
 *
 * @property statusCallback - The URL we should call using a POST method to send status information to your application
 * @property uniqueName - An application-defined string that uniquely identifies the new resource
 */
interface ModelBuildListInstanceCreateOptions {
  statusCallback?: string;
  uniqueName?: string;
}

/**
 * Options to pass to each
 *
 * @property callback -
 *                         Function to process each record. If this and a positional
 *                         callback are passed, this one will be used
 * @property done - Function to be called upon completion of streaming
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         each() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no pageSize is defined but a limit is defined,
 *                         each() will attempt to read the limit with the most efficient
 *                         page size, i.e. min(limit, 1000)
 */
interface ModelBuildListInstanceEachOptions {
  callback?: (item: ModelBuildInstance, done: (err?: Error) => void) => void;
  done?: Function;
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to list
 *
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         list() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no page_size is defined but a limit is defined,
 *                         list() will attempt to read the limit with the most
 *                         efficient page size, i.e. min(limit, 1000)
 */
interface ModelBuildListInstanceOptions {
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to page
 *
 * @property pageNumber - Page Number, this value is simply for client state
 * @property pageSize - Number of records to return, defaults to 50
 * @property pageToken - PageToken provided by the API
 */
interface ModelBuildListInstancePageOptions {
  pageNumber?: number;
  pageSize?: number;
  pageToken?: string;
}

interface ModelBuildPayload extends ModelBuildResource, Page.TwilioResponsePayload {
}

interface ModelBuildResource {
  account_sid: string;
  assistant_sid: string;
  build_duration: number;
  date_created: Date;
  date_updated: Date;
  error_code: number;
  sid: string;
  status: ModelBuildStatus;
  unique_name: string;
  url: string;
}

interface ModelBuildSolution {
  assistantSid?: string;
}


declare class ModelBuildContext {
  /**
   * Initialize the ModelBuildContext
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param assistantSid - The SID of the Assistant that is the parent of the resource to fetch
   * @param sid - The unique string that identifies the resource
   */
  constructor(version: V1, assistantSid: string, sid: string);

  /**
   * fetch a ModelBuildInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: ModelBuildInstance) => any): Promise<ModelBuildInstance>;
  /**
   * remove a ModelBuildInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: ModelBuildInstance) => any): Promise<boolean>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a ModelBuildInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: ModelBuildInstanceUpdateOptions, callback?: (error: Error | null, items: ModelBuildInstance) => any): Promise<ModelBuildInstance>;
}


declare class ModelBuildInstance extends SerializableClass {
  /**
   * Initialize the ModelBuildContext
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param assistantSid - The SID of the Assistant that is the parent of the resource
   * @param sid - The unique string that identifies the resource
   */
  constructor(version: V1, payload: ModelBuildPayload, assistantSid: string, sid: string);

  private _proxy: ModelBuildContext;
  accountSid: string;
  assistantSid: string;
  buildDuration: number;
  dateCreated: Date;
  dateUpdated: Date;
  errorCode: number;
  /**
   * fetch a ModelBuildInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: ModelBuildInstance) => any): Promise<ModelBuildInstance>;
  /**
   * remove a ModelBuildInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: ModelBuildInstance) => any): Promise<boolean>;
  sid: string;
  status: ModelBuildStatus;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  uniqueName: string;
  /**
   * update a ModelBuildInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: ModelBuildInstanceUpdateOptions, callback?: (error: Error | null, items: ModelBuildInstance) => any): Promise<ModelBuildInstance>;
  url: string;
}


declare class ModelBuildPage extends Page<V1, ModelBuildPayload, ModelBuildResource, ModelBuildInstance> {
  /**
   * Initialize the ModelBuildPage
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: ModelBuildSolution);

  /**
   * Build an instance of ModelBuildInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: ModelBuildPayload): ModelBuildInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { ModelBuildContext, ModelBuildInstance, ModelBuildInstanceUpdateOptions, ModelBuildList, ModelBuildListInstance, ModelBuildListInstanceCreateOptions, ModelBuildListInstanceEachOptions, ModelBuildListInstanceOptions, ModelBuildListInstancePageOptions, ModelBuildPage, ModelBuildPayload, ModelBuildResource, ModelBuildSolution, ModelBuildStatus }
