/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../../base/Page');
import Response = require('../../../../http/response');
import V1 = require('../../V1');
import { SerializableClass } from '../../../../interfaces';

type ExportAssistantStatus = 'completed'|'failed';

/**
 * Initialize the ExportAssistantList
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @param version - Version of the resource
 * @param assistantSid - The SID of the Assistant to export.
 */
declare function ExportAssistantList(version: V1, assistantSid: string): ExportAssistantListInstance;

interface ExportAssistantListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): ExportAssistantContext;
  /**
   * Constructs a export_assistant
   */
  get(): ExportAssistantContext;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

interface ExportAssistantPayload extends ExportAssistantResource, Page.TwilioResponsePayload {
}

interface ExportAssistantResource {
  account_sid: string;
  assistant_sid: string;
  date_created: Date;
  error_code: number;
  schema: object;
  status: ExportAssistantStatus;
  url: string;
}

interface ExportAssistantSolution {
  assistantSid?: string;
}


declare class ExportAssistantContext {
  /**
   * Initialize the ExportAssistantContext
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param assistantSid - The SID of the Assistant to export.
   */
  constructor(version: V1, assistantSid: string);

  /**
   * fetch a ExportAssistantInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: ExportAssistantInstance) => any): Promise<ExportAssistantInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class ExportAssistantInstance extends SerializableClass {
  /**
   * Initialize the ExportAssistantContext
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param assistantSid - The SID of the Assistant to export.
   */
  constructor(version: V1, payload: ExportAssistantPayload, assistantSid: string);

  private _proxy: ExportAssistantContext;
  accountSid: string;
  assistantSid: string;
  dateCreated: Date;
  errorCode: number;
  /**
   * fetch a ExportAssistantInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: ExportAssistantInstance) => any): Promise<ExportAssistantInstance>;
  schema: object;
  status: ExportAssistantStatus;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  url: string;
}


declare class ExportAssistantPage extends Page<V1, ExportAssistantPayload, ExportAssistantResource, ExportAssistantInstance> {
  /**
   * Initialize the ExportAssistantPage
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: ExportAssistantSolution);

  /**
   * Build an instance of ExportAssistantInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: ExportAssistantPayload): ExportAssistantInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { ExportAssistantContext, ExportAssistantInstance, ExportAssistantList, ExportAssistantListInstance, ExportAssistantPage, ExportAssistantPayload, ExportAssistantResource, ExportAssistantSolution, ExportAssistantStatus }
