/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../../../../base/Page');
import Response = require('../../../../../../http/response');
import V1 = require('../../../../V1');
import serialize = require('../../../../../../base/serialize');
import { SerializableClass } from '../../../../../../interfaces';

type ChallengeChallengeReasons = 'none'|'not_needed'|'not_requested';

type ChallengeChallengeStatuses = 'pending'|'expired'|'approved'|'denied';

type ChallengeFactorTypes = 'app-push'|'sms'|'totp'|'push';

/**
 * Initialize the ChallengeList
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @param version - Version of the resource
 * @param serviceSid - Service Sid.
 * @param identity - Unique identity of the Entity
 * @param factorSid - Factor Sid.
 */
declare function ChallengeList(version: V1, serviceSid: string, identity: string, factorSid: string): ChallengeListInstance;

/**
 * Options to pass to fetch
 *
 * @property twilioAuthySandboxMode - The Twilio-Authy-Sandbox-Mode HTTP request header
 */
interface ChallengeInstanceFetchOptions {
  twilioAuthySandboxMode?: string;
}

/**
 * Options to pass to remove
 *
 * @property twilioAuthySandboxMode - The Twilio-Authy-Sandbox-Mode HTTP request header
 */
interface ChallengeInstanceRemoveOptions {
  twilioAuthySandboxMode?: string;
}

/**
 * Options to pass to update
 *
 * @property authPayload - Optional payload to verify the Challenge
 * @property twilioAuthySandboxMode - The Twilio-Authy-Sandbox-Mode HTTP request header
 */
interface ChallengeInstanceUpdateOptions {
  authPayload?: string;
  twilioAuthySandboxMode?: string;
}

interface ChallengeListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): ChallengeContext;
  /**
   * create a ChallengeInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  create(opts?: ChallengeListInstanceCreateOptions, callback?: (error: Error | null, item: ChallengeInstance) => any): Promise<ChallengeInstance>;
  /**
   * Constructs a challenge
   *
   * @param sid - A string that uniquely identifies this Challenge, or `latest`.
   */
  get(sid: string): ChallengeContext;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to create
 *
 * @property details - Public details provided to contextualize the Challenge
 * @property expirationDate - The future date in which this Challenge will expire
 * @property hiddenDetails - Hidden details provided to contextualize the Challenge
 * @property twilioAuthySandboxMode - The Twilio-Authy-Sandbox-Mode HTTP request header
 */
interface ChallengeListInstanceCreateOptions {
  details?: string;
  expirationDate?: Date;
  hiddenDetails?: string;
  twilioAuthySandboxMode?: string;
}

interface ChallengePayload extends ChallengeResource, Page.TwilioResponsePayload {
}

interface ChallengeResource {
  account_sid: string;
  date_created: Date;
  date_responded: Date;
  date_updated: Date;
  details: string;
  entity_sid: string;
  expiration_date: Date;
  factor_sid: string;
  factor_type: ChallengeFactorTypes;
  hidden_details: string;
  identity: string;
  responded_reason: ChallengeChallengeReasons;
  service_sid: string;
  sid: string;
  status: ChallengeChallengeStatuses;
  url: string;
}

interface ChallengeSolution {
  factorSid?: string;
  identity?: string;
  serviceSid?: string;
}


declare class ChallengeContext {
  /**
   * Initialize the ChallengeContext
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param serviceSid - Service Sid.
   * @param identity - Unique identity of the Entity
   * @param factorSid - Factor Sid.
   * @param sid - A string that uniquely identifies this Challenge, or `latest`.
   */
  constructor(version: V1, serviceSid: string, identity: string, factorSid: string, sid: string);

  /**
   * fetch a ChallengeInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  fetch(opts?: ChallengeInstanceFetchOptions, callback?: (error: Error | null, items: ChallengeInstance) => any): Promise<ChallengeInstance>;
  /**
   * remove a ChallengeInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  remove(opts?: ChallengeInstanceRemoveOptions, callback?: (error: Error | null, items: ChallengeInstance) => any): Promise<boolean>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a ChallengeInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: ChallengeInstanceUpdateOptions, callback?: (error: Error | null, items: ChallengeInstance) => any): Promise<ChallengeInstance>;
}


declare class ChallengeInstance extends SerializableClass {
  /**
   * Initialize the ChallengeContext
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param serviceSid - Service Sid.
   * @param identity - Unique identity of the Entity
   * @param factorSid - Factor Sid.
   * @param sid - A string that uniquely identifies this Challenge, or `latest`.
   */
  constructor(version: V1, payload: ChallengePayload, serviceSid: string, identity: string, factorSid: string, sid: string);

  private _proxy: ChallengeContext;
  accountSid: string;
  dateCreated: Date;
  dateResponded: Date;
  dateUpdated: Date;
  details: string;
  entitySid: string;
  expirationDate: Date;
  factorSid: string;
  factorType: ChallengeFactorTypes;
  /**
   * fetch a ChallengeInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  fetch(opts?: ChallengeInstanceFetchOptions, callback?: (error: Error | null, items: ChallengeInstance) => any): Promise<ChallengeInstance>;
  hiddenDetails: string;
  identity: string;
  /**
   * remove a ChallengeInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  remove(opts?: ChallengeInstanceRemoveOptions, callback?: (error: Error | null, items: ChallengeInstance) => any): Promise<boolean>;
  respondedReason: ChallengeChallengeReasons;
  serviceSid: string;
  sid: string;
  status: ChallengeChallengeStatuses;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a ChallengeInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: ChallengeInstanceUpdateOptions, callback?: (error: Error | null, items: ChallengeInstance) => any): Promise<ChallengeInstance>;
  url: string;
}


declare class ChallengePage extends Page<V1, ChallengePayload, ChallengeResource, ChallengeInstance> {
  /**
   * Initialize the ChallengePage
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: ChallengeSolution);

  /**
   * Build an instance of ChallengeInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: ChallengePayload): ChallengeInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { ChallengeChallengeReasons, ChallengeChallengeStatuses, ChallengeContext, ChallengeFactorTypes, ChallengeInstance, ChallengeInstanceFetchOptions, ChallengeInstanceRemoveOptions, ChallengeInstanceUpdateOptions, ChallengeList, ChallengeListInstance, ChallengeListInstanceCreateOptions, ChallengePage, ChallengePayload, ChallengeResource, ChallengeSolution }
