/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../../base/Page');
import Response = require('../../../../http/response');
import V2010 = require('../../V2010');
import { SerializableClass } from '../../../../interfaces';

/**
 * Initialize the TokenList
 *
 * @param version - Version of the resource
 * @param accountSid - The SID of the Account that created the resource
 */
declare function TokenList(version: V2010, accountSid: string): TokenListInstance;

interface TokenListInstance {
  /**
   * create a TokenInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  create(opts?: TokenListInstanceCreateOptions, callback?: (error: Error | null, item: TokenInstance) => any): Promise<TokenInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to create
 *
 * @property ttl - The duration in seconds the credentials are valid
 */
interface TokenListInstanceCreateOptions {
  ttl?: number;
}

interface TokenPayload extends TokenResource, Page.TwilioResponsePayload {
}

interface TokenResource {
  account_sid: string;
  date_created: Date;
  date_updated: Date;
  ice_servers: string[];
  password: string;
  ttl: string;
  username: string;
}

interface TokenSolution {
  accountSid?: string;
}


declare class TokenInstance extends SerializableClass {
  /**
   * Initialize the TokenContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param accountSid - The SID of the Account that created the resource
   */
  constructor(version: V2010, payload: TokenPayload, accountSid: string);

  accountSid: string;
  dateCreated: Date;
  dateUpdated: Date;
  iceServers: string[];
  password: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  ttl: string;
  username: string;
}


declare class TokenPage extends Page<V2010, TokenPayload, TokenResource, TokenInstance> {
  /**
   * Initialize the TokenPage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V2010, response: Response<string>, solution: TokenSolution);

  /**
   * Build an instance of TokenInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: TokenPayload): TokenInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { TokenInstance, TokenList, TokenListInstance, TokenListInstanceCreateOptions, TokenPage, TokenPayload, TokenResource, TokenSolution }
