'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var Page = require('../../../../../../base/Page');  /* jshint ignore:line */
var values = require('../../../../../../base/values');  /* jshint ignore:line */

var AssignedAddOnExtensionList;
var AssignedAddOnExtensionPage;
var AssignedAddOnExtensionInstance;
var AssignedAddOnExtensionContext;

/* jshint ignore:start */
/**
 * Initialize the AssignedAddOnExtensionList
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Api.V2010.AccountContext.IncomingPhoneNumberContext.AssignedAddOnContext.AssignedAddOnExtensionList
 *
 * @param {Twilio.Api.V2010} version - Version of the resource
 * @param {string} accountSid - The SID of the Account that created the resource
 * @param {string} resourceSid -
 *          The SID of the Phone Number to which the Add-on is assigned
 * @param {string} assignedAddOnSid -
 *          The SID that uniquely identifies the assigned Add-on installation
 */
/* jshint ignore:end */
AssignedAddOnExtensionList = function AssignedAddOnExtensionList(version,
    accountSid, resourceSid, assignedAddOnSid) {
  /* jshint ignore:start */
  /**
   * @function extensions
   * @memberof Twilio.Api.V2010.AccountContext.IncomingPhoneNumberContext.AssignedAddOnContext#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Api.V2010.AccountContext.IncomingPhoneNumberContext.AssignedAddOnContext.AssignedAddOnExtensionContext}
   */
  /* jshint ignore:end */
  function AssignedAddOnExtensionListInstance(sid) {
    return AssignedAddOnExtensionListInstance.get(sid);
  }

  AssignedAddOnExtensionListInstance._version = version;
  // Path Solution
  AssignedAddOnExtensionListInstance._solution = {
    accountSid: accountSid,
    resourceSid: resourceSid,
    assignedAddOnSid: assignedAddOnSid
  };
  AssignedAddOnExtensionListInstance._uri = `/Accounts/${accountSid}/IncomingPhoneNumbers/${resourceSid}/AssignedAddOns/${assignedAddOnSid}/Extensions.json`;
  /* jshint ignore:start */
  /**
   * Streams AssignedAddOnExtensionInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function each
   * @memberof Twilio.Api.V2010.AccountContext.IncomingPhoneNumberContext.AssignedAddOnContext.AssignedAddOnExtensionList#
   *
   * @param {object} [opts] - Options for request
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         each() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no pageSize is defined but a limit is defined,
   *         each() will attempt to read the limit with the most efficient
   *         page size, i.e. min(limit, 1000)
   * @param {Function} [opts.callback] -
   *         Function to process each record. If this and a positional
   *         callback are passed, this one will be used
   * @param {Function} [opts.done] -
   *          Function to be called upon completion of streaming
   * @param {Function} [callback] - Function to process each record
   */
  /* jshint ignore:end */
  AssignedAddOnExtensionListInstance.each = function each(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    if (opts.callback) {
      callback = opts.callback;
    }
    if (_.isUndefined(callback)) {
      throw new Error('Callback function must be provided');
    }

    var done = false;
    var currentPage = 1;
    var currentResource = 0;
    var limits = this._version.readLimits({
      limit: opts.limit,
      pageSize: opts.pageSize
    });

    function onComplete(error) {
      done = true;
      if (_.isFunction(opts.done)) {
        opts.done(error);
      }
    }

    function fetchNextPage(fn) {
      var promise = fn();
      if (_.isUndefined(promise)) {
        onComplete();
        return;
      }

      promise.then(function(page) {
        _.each(page.instances, function(instance) {
          if (done || (!_.isUndefined(opts.limit) && currentResource >= opts.limit)) {
            done = true;
            return false;
          }

          currentResource++;
          callback(instance, onComplete);
        });

        if ((limits.pageLimit && limits.pageLimit <= currentPage)) {
          onComplete();
        } else if (!done) {
          currentPage++;
          fetchNextPage(_.bind(page.nextPage, page));
        }
      });

      promise.catch(onComplete);
    }

    fetchNextPage(_.bind(this.page, this, _.merge(opts, limits)));
  };

  /* jshint ignore:start */
  /**
   * Lists AssignedAddOnExtensionInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function list
   * @memberof Twilio.Api.V2010.AccountContext.IncomingPhoneNumberContext.AssignedAddOnContext.AssignedAddOnExtensionList#
   *
   * @param {object} [opts] - Options for request
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         list() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no page_size is defined but a limit is defined,
   *         list() will attempt to read the limit with the most
   *         efficient page size, i.e. min(limit, 1000)
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  AssignedAddOnExtensionListInstance.list = function list(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    var deferred = Q.defer();
    var allResources = [];
    opts.callback = function(resource, done) {
      allResources.push(resource);

      if (!_.isUndefined(opts.limit) && allResources.length === opts.limit) {
        done();
      }
    };

    opts.done = function(error) {
      if (_.isUndefined(error)) {
        deferred.resolve(allResources);
      } else {
        deferred.reject(error);
      }
    };

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    this.each(opts);
    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single page of AssignedAddOnExtensionInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function page
   * @memberof Twilio.Api.V2010.AccountContext.IncomingPhoneNumberContext.AssignedAddOnContext.AssignedAddOnExtensionList#
   *
   * @param {object} [opts] - Options for request
   * @param {string} [opts.pageToken] - PageToken provided by the API
   * @param {number} [opts.pageNumber] -
   *          Page Number, this value is simply for client state
   * @param {number} [opts.pageSize] - Number of records to return, defaults to 50
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  AssignedAddOnExtensionListInstance.page = function page(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};

    var deferred = Q.defer();
    var data = values.of({
      'PageToken': opts.pageToken,
      'Page': opts.pageNumber,
      'PageSize': opts.pageSize
    });

    var promise = this._version.page({uri: this._uri, method: 'GET', params: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new AssignedAddOnExtensionPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single target page of AssignedAddOnExtensionInstance records from the
   * API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function getPage
   * @memberof Twilio.Api.V2010.AccountContext.IncomingPhoneNumberContext.AssignedAddOnContext.AssignedAddOnExtensionList#
   *
   * @param {string} [targetUrl] - API-generated URL for the requested results page
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  AssignedAddOnExtensionListInstance.getPage = function getPage(targetUrl,
      callback) {
    var deferred = Q.defer();

    var promise = this._version._domain.twilio.request({method: 'GET', uri: targetUrl});

    promise = promise.then(function(payload) {
      deferred.resolve(new AssignedAddOnExtensionPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Constructs a assigned_add_on_extension
   *
   * @function get
   * @memberof Twilio.Api.V2010.AccountContext.IncomingPhoneNumberContext.AssignedAddOnContext.AssignedAddOnExtensionList#
   *
   * @param {string} sid - The unique string that identifies the resource
   *
   * @returns {Twilio.Api.V2010.AccountContext.IncomingPhoneNumberContext.AssignedAddOnContext.AssignedAddOnExtensionContext}
   */
  /* jshint ignore:end */
  AssignedAddOnExtensionListInstance.get = function get(sid) {
    return new AssignedAddOnExtensionContext(
      this._version,
      this._solution.accountSid,
      this._solution.resourceSid,
      this._solution.assignedAddOnSid,
      sid
    );
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Api.V2010.AccountContext.IncomingPhoneNumberContext.AssignedAddOnContext.AssignedAddOnExtensionList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  AssignedAddOnExtensionListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  AssignedAddOnExtensionListInstance[util.inspect.custom] = function
      inspect(depth, options) {
    return util.inspect(this.toJSON(), options);
  };

  return AssignedAddOnExtensionListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the AssignedAddOnExtensionPage
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Api.V2010.AccountContext.IncomingPhoneNumberContext.AssignedAddOnContext.AssignedAddOnExtensionPage
 *
 * @param {V2010} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {AssignedAddOnExtensionSolution} solution - Path solution
 *
 * @returns AssignedAddOnExtensionPage
 */
/* jshint ignore:end */
AssignedAddOnExtensionPage = function AssignedAddOnExtensionPage(version,
    response, solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(AssignedAddOnExtensionPage.prototype, Page.prototype);
AssignedAddOnExtensionPage.prototype.constructor = AssignedAddOnExtensionPage;

/* jshint ignore:start */
/**
 * Build an instance of AssignedAddOnExtensionInstance
 *
 * @function getInstance
 * @memberof Twilio.Api.V2010.AccountContext.IncomingPhoneNumberContext.AssignedAddOnContext.AssignedAddOnExtensionPage#
 *
 * @param {AssignedAddOnExtensionPayload} payload - Payload response from the API
 *
 * @returns AssignedAddOnExtensionInstance
 */
/* jshint ignore:end */
AssignedAddOnExtensionPage.prototype.getInstance = function getInstance(payload)
    {
  return new AssignedAddOnExtensionInstance(
    this._version,
    payload,
    this._solution.accountSid,
    this._solution.resourceSid,
    this._solution.assignedAddOnSid
  );
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Api.V2010.AccountContext.IncomingPhoneNumberContext.AssignedAddOnContext.AssignedAddOnExtensionPage#
 *
 * @returns Object
 */
/* jshint ignore:end */
AssignedAddOnExtensionPage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

AssignedAddOnExtensionPage.prototype[util.inspect.custom] = function
    inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the AssignedAddOnExtensionContext
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Api.V2010.AccountContext.IncomingPhoneNumberContext.AssignedAddOnContext.AssignedAddOnExtensionInstance
 *
 * @property {string} sid - The unique string that identifies the resource
 * @property {string} accountSid - The SID of the Account that created the resource
 * @property {string} resourceSid -
 *          The SID of the Phone Number to which the Add-on is assigned
 * @property {string} assignedAddOnSid -
 *          The SID that uniquely identifies the assigned Add-on installation
 * @property {string} friendlyName -
 *          The string that you assigned to describe the resource
 * @property {string} productName -
 *          A string that you assigned to describe the Product this Extension is used within
 * @property {string} uniqueName -
 *          An application-defined string that uniquely identifies the resource
 * @property {string} uri -
 *          The URI of the resource, relative to `https://api.twilio.com`
 * @property {boolean} enabled - Whether the Extension will be invoked
 *
 * @param {V2010} version - Version of the resource
 * @param {AssignedAddOnExtensionPayload} payload - The instance payload
 * @param {sid} accountSid - The SID of the Account that created the resource
 * @param {sid} resourceSid -
 *          The SID of the Phone Number to which the Add-on is assigned
 * @param {sid} assignedAddOnSid -
 *          The SID that uniquely identifies the assigned Add-on installation
 * @param {sid} sid - The unique string that identifies the resource
 */
/* jshint ignore:end */
AssignedAddOnExtensionInstance = function
    AssignedAddOnExtensionInstance(version, payload, accountSid, resourceSid,
    assignedAddOnSid, sid) {
  this._version = version;

  // Marshaled Properties
  this.sid = payload.sid; // jshint ignore:line
  this.accountSid = payload.account_sid; // jshint ignore:line
  this.resourceSid = payload.resource_sid; // jshint ignore:line
  this.assignedAddOnSid = payload.assigned_add_on_sid; // jshint ignore:line
  this.friendlyName = payload.friendly_name; // jshint ignore:line
  this.productName = payload.product_name; // jshint ignore:line
  this.uniqueName = payload.unique_name; // jshint ignore:line
  this.uri = payload.uri; // jshint ignore:line
  this.enabled = payload.enabled; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {
    accountSid: accountSid,
    resourceSid: resourceSid,
    assignedAddOnSid: assignedAddOnSid,
    sid: sid || this.sid,
  };
};

Object.defineProperty(AssignedAddOnExtensionInstance.prototype,
  '_proxy', {
    get: function() {
      if (!this._context) {
        this._context = new AssignedAddOnExtensionContext(
          this._version,
          this._solution.accountSid,
          this._solution.resourceSid,
          this._solution.assignedAddOnSid,
          this._solution.sid
        );
      }

      return this._context;
    }
});

/* jshint ignore:start */
/**
 * fetch a AssignedAddOnExtensionInstance
 *
 * @function fetch
 * @memberof Twilio.Api.V2010.AccountContext.IncomingPhoneNumberContext.AssignedAddOnContext.AssignedAddOnExtensionInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed AssignedAddOnExtensionInstance
 */
/* jshint ignore:end */
AssignedAddOnExtensionInstance.prototype.fetch = function fetch(callback) {
  return this._proxy.fetch(callback);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Api.V2010.AccountContext.IncomingPhoneNumberContext.AssignedAddOnContext.AssignedAddOnExtensionInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
AssignedAddOnExtensionInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

AssignedAddOnExtensionInstance.prototype[util.inspect.custom] = function
    inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the AssignedAddOnExtensionContext
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Api.V2010.AccountContext.IncomingPhoneNumberContext.AssignedAddOnContext.AssignedAddOnExtensionContext
 *
 * @param {V2010} version - Version of the resource
 * @param {sid} accountSid -
 *          The SID of the Account that created the resource to fetch
 * @param {sid} resourceSid -
 *          The SID of the Phone Number to which the Add-on is assigned
 * @param {sid} assignedAddOnSid -
 *          The SID that uniquely identifies the assigned Add-on installation
 * @param {sid} sid - The unique string that identifies the resource
 */
/* jshint ignore:end */
AssignedAddOnExtensionContext = function AssignedAddOnExtensionContext(version,
    accountSid, resourceSid, assignedAddOnSid, sid) {
  this._version = version;

  // Path Solution
  this._solution = {
    accountSid: accountSid,
    resourceSid: resourceSid,
    assignedAddOnSid: assignedAddOnSid,
    sid: sid,
  };
  this._uri = `/Accounts/${accountSid}/IncomingPhoneNumbers/${resourceSid}/AssignedAddOns/${assignedAddOnSid}/Extensions/${sid}.json`;
};

/* jshint ignore:start */
/**
 * fetch a AssignedAddOnExtensionInstance
 *
 * @function fetch
 * @memberof Twilio.Api.V2010.AccountContext.IncomingPhoneNumberContext.AssignedAddOnContext.AssignedAddOnExtensionContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed AssignedAddOnExtensionInstance
 */
/* jshint ignore:end */
AssignedAddOnExtensionContext.prototype.fetch = function fetch(callback) {
  var deferred = Q.defer();
  var promise = this._version.fetch({uri: this._uri, method: 'GET'});

  promise = promise.then(function(payload) {
    deferred.resolve(new AssignedAddOnExtensionInstance(
      this._version,
      payload,
      this._solution.accountSid,
      this._solution.resourceSid,
      this._solution.assignedAddOnSid,
      this._solution.sid
    ));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Api.V2010.AccountContext.IncomingPhoneNumberContext.AssignedAddOnContext.AssignedAddOnExtensionContext#
 *
 * @returns Object
 */
/* jshint ignore:end */
AssignedAddOnExtensionContext.prototype.toJSON = function toJSON() {
  return this._solution;
};

AssignedAddOnExtensionContext.prototype[util.inspect.custom] = function
    inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  AssignedAddOnExtensionList: AssignedAddOnExtensionList,
  AssignedAddOnExtensionPage: AssignedAddOnExtensionPage,
  AssignedAddOnExtensionInstance: AssignedAddOnExtensionInstance,
  AssignedAddOnExtensionContext: AssignedAddOnExtensionContext
};
