'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var Page = require('../../../../../base/Page');  /* jshint ignore:line */
var deserialize = require(
    '../../../../../base/deserialize');  /* jshint ignore:line */
var serialize = require(
    '../../../../../base/serialize');  /* jshint ignore:line */
var values = require('../../../../../base/values');  /* jshint ignore:line */

var RecordingList;
var RecordingPage;
var RecordingInstance;
var RecordingContext;

/* jshint ignore:start */
/**
 * Initialize the RecordingList
 *
 * @constructor Twilio.Api.V2010.AccountContext.ConferenceContext.RecordingList
 *
 * @param {Twilio.Api.V2010} version - Version of the resource
 * @param {string} accountSid - The SID of the Account that created the resource
 * @param {string} conferenceSid -
 *          The Conference SID that identifies the conference associated with the recording
 */
/* jshint ignore:end */
RecordingList = function RecordingList(version, accountSid, conferenceSid) {
  /* jshint ignore:start */
  /**
   * @function recordings
   * @memberof Twilio.Api.V2010.AccountContext.ConferenceContext#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Api.V2010.AccountContext.ConferenceContext.RecordingContext}
   */
  /* jshint ignore:end */
  function RecordingListInstance(sid) {
    return RecordingListInstance.get(sid);
  }

  RecordingListInstance._version = version;
  // Path Solution
  RecordingListInstance._solution = {accountSid: accountSid, conferenceSid: conferenceSid};
  RecordingListInstance._uri = `/Accounts/${accountSid}/Conferences/${conferenceSid}/Recordings.json`;
  /* jshint ignore:start */
  /**
   * Streams RecordingInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function each
   * @memberof Twilio.Api.V2010.AccountContext.ConferenceContext.RecordingList#
   *
   * @param {object} [opts] - Options for request
   * @param {Date} [opts.dateCreatedBefore] -
   *          The `YYYY-MM-DD` value of the resources to read
   * @param {Date} [opts.dateCreated] -
   *          The `YYYY-MM-DD` value of the resources to read
   * @param {Date} [opts.dateCreatedAfter] -
   *          The `YYYY-MM-DD` value of the resources to read
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         each() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no pageSize is defined but a limit is defined,
   *         each() will attempt to read the limit with the most efficient
   *         page size, i.e. min(limit, 1000)
   * @param {Function} [opts.callback] -
   *         Function to process each record. If this and a positional
   *         callback are passed, this one will be used
   * @param {Function} [opts.done] -
   *          Function to be called upon completion of streaming
   * @param {Function} [callback] - Function to process each record
   */
  /* jshint ignore:end */
  RecordingListInstance.each = function each(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    if (opts.callback) {
      callback = opts.callback;
    }
    if (_.isUndefined(callback)) {
      throw new Error('Callback function must be provided');
    }

    var done = false;
    var currentPage = 1;
    var currentResource = 0;
    var limits = this._version.readLimits({
      limit: opts.limit,
      pageSize: opts.pageSize
    });

    function onComplete(error) {
      done = true;
      if (_.isFunction(opts.done)) {
        opts.done(error);
      }
    }

    function fetchNextPage(fn) {
      var promise = fn();
      if (_.isUndefined(promise)) {
        onComplete();
        return;
      }

      promise.then(function(page) {
        _.each(page.instances, function(instance) {
          if (done || (!_.isUndefined(opts.limit) && currentResource >= opts.limit)) {
            done = true;
            return false;
          }

          currentResource++;
          callback(instance, onComplete);
        });

        if ((limits.pageLimit && limits.pageLimit <= currentPage)) {
          onComplete();
        } else if (!done) {
          currentPage++;
          fetchNextPage(_.bind(page.nextPage, page));
        }
      });

      promise.catch(onComplete);
    }

    fetchNextPage(_.bind(this.page, this, _.merge(opts, limits)));
  };

  /* jshint ignore:start */
  /**
   * Lists RecordingInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function list
   * @memberof Twilio.Api.V2010.AccountContext.ConferenceContext.RecordingList#
   *
   * @param {object} [opts] - Options for request
   * @param {Date} [opts.dateCreatedBefore] -
   *          The `YYYY-MM-DD` value of the resources to read
   * @param {Date} [opts.dateCreated] -
   *          The `YYYY-MM-DD` value of the resources to read
   * @param {Date} [opts.dateCreatedAfter] -
   *          The `YYYY-MM-DD` value of the resources to read
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         list() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no page_size is defined but a limit is defined,
   *         list() will attempt to read the limit with the most
   *         efficient page size, i.e. min(limit, 1000)
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  RecordingListInstance.list = function list(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    var deferred = Q.defer();
    var allResources = [];
    opts.callback = function(resource, done) {
      allResources.push(resource);

      if (!_.isUndefined(opts.limit) && allResources.length === opts.limit) {
        done();
      }
    };

    opts.done = function(error) {
      if (_.isUndefined(error)) {
        deferred.resolve(allResources);
      } else {
        deferred.reject(error);
      }
    };

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    this.each(opts);
    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single page of RecordingInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function page
   * @memberof Twilio.Api.V2010.AccountContext.ConferenceContext.RecordingList#
   *
   * @param {object} [opts] - Options for request
   * @param {Date} [opts.dateCreatedBefore] -
   *          The `YYYY-MM-DD` value of the resources to read
   * @param {Date} [opts.dateCreated] -
   *          The `YYYY-MM-DD` value of the resources to read
   * @param {Date} [opts.dateCreatedAfter] -
   *          The `YYYY-MM-DD` value of the resources to read
   * @param {string} [opts.pageToken] - PageToken provided by the API
   * @param {number} [opts.pageNumber] -
   *          Page Number, this value is simply for client state
   * @param {number} [opts.pageSize] - Number of records to return, defaults to 50
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  RecordingListInstance.page = function page(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};

    var deferred = Q.defer();
    var data = values.of({
      'DateCreated<': serialize.iso8601Date(_.get(opts, 'dateCreatedBefore')),
      'DateCreated': serialize.iso8601Date(_.get(opts, 'dateCreated')),
      'DateCreated>': serialize.iso8601Date(_.get(opts, 'dateCreatedAfter')),
      'PageToken': opts.pageToken,
      'Page': opts.pageNumber,
      'PageSize': opts.pageSize
    });

    var promise = this._version.page({uri: this._uri, method: 'GET', params: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new RecordingPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single target page of RecordingInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function getPage
   * @memberof Twilio.Api.V2010.AccountContext.ConferenceContext.RecordingList#
   *
   * @param {string} [targetUrl] - API-generated URL for the requested results page
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  RecordingListInstance.getPage = function getPage(targetUrl, callback) {
    var deferred = Q.defer();

    var promise = this._version._domain.twilio.request({method: 'GET', uri: targetUrl});

    promise = promise.then(function(payload) {
      deferred.resolve(new RecordingPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Constructs a recording
   *
   * @function get
   * @memberof Twilio.Api.V2010.AccountContext.ConferenceContext.RecordingList#
   *
   * @param {string} sid - The unique string that identifies the resource
   *
   * @returns {Twilio.Api.V2010.AccountContext.ConferenceContext.RecordingContext}
   */
  /* jshint ignore:end */
  RecordingListInstance.get = function get(sid) {
    return new RecordingContext(
      this._version,
      this._solution.accountSid,
      this._solution.conferenceSid,
      sid
    );
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Api.V2010.AccountContext.ConferenceContext.RecordingList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  RecordingListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  RecordingListInstance[util.inspect.custom] = function inspect(depth, options) {
    return util.inspect(this.toJSON(), options);
  };

  return RecordingListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the RecordingPage
 *
 * @constructor Twilio.Api.V2010.AccountContext.ConferenceContext.RecordingPage
 *
 * @param {V2010} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {RecordingSolution} solution - Path solution
 *
 * @returns RecordingPage
 */
/* jshint ignore:end */
RecordingPage = function RecordingPage(version, response, solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(RecordingPage.prototype, Page.prototype);
RecordingPage.prototype.constructor = RecordingPage;

/* jshint ignore:start */
/**
 * Build an instance of RecordingInstance
 *
 * @function getInstance
 * @memberof Twilio.Api.V2010.AccountContext.ConferenceContext.RecordingPage#
 *
 * @param {RecordingPayload} payload - Payload response from the API
 *
 * @returns RecordingInstance
 */
/* jshint ignore:end */
RecordingPage.prototype.getInstance = function getInstance(payload) {
  return new RecordingInstance(
    this._version,
    payload,
    this._solution.accountSid,
    this._solution.conferenceSid
  );
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Api.V2010.AccountContext.ConferenceContext.RecordingPage#
 *
 * @returns Object
 */
/* jshint ignore:end */
RecordingPage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

RecordingPage.prototype[util.inspect.custom] = function inspect(depth, options)
    {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the RecordingContext
 *
 * @constructor Twilio.Api.V2010.AccountContext.ConferenceContext.RecordingInstance
 *
 * @property {string} accountSid - The SID of the Account that created the resource
 * @property {string} apiVersion - The API version used to create the recording
 * @property {string} callSid - The SID of the Call the resource is associated with
 * @property {string} conferenceSid -
 *          The Conference SID that identifies the conference associated with the recording
 * @property {Date} dateCreated -
 *          The RFC 2822 date and time in GMT that the resource was created
 * @property {Date} dateUpdated -
 *          The RFC 2822 date and time in GMT that the resource was last updated
 * @property {Date} startTime -
 *          The start time of the recording, given in RFC 2822 format
 * @property {string} duration - The length of the recording in seconds
 * @property {string} sid - The unique string that identifies the resource
 * @property {number} price - The one-time cost of creating the recording.
 * @property {string} priceUnit - The currency used in the price property.
 * @property {recording.status} status - The status of the recording
 * @property {number} channels -
 *          The number of channels in the final recording file as an integer
 * @property {recording.source} source - How the recording was created
 * @property {number} errorCode -
 *          More information about why the recording is missing, if status is `absent`.
 * @property {object} encryptionDetails - How to decrypt the recording.
 * @property {string} uri -
 *          The URI of the resource, relative to `https://api.twilio.com`
 *
 * @param {V2010} version - Version of the resource
 * @param {RecordingPayload} payload - The instance payload
 * @param {sid} accountSid - The SID of the Account that created the resource
 * @param {sid} conferenceSid -
 *          The Conference SID that identifies the conference associated with the recording
 * @param {sid} sid - The unique string that identifies the resource
 */
/* jshint ignore:end */
RecordingInstance = function RecordingInstance(version, payload, accountSid,
                                                conferenceSid, sid) {
  this._version = version;

  // Marshaled Properties
  this.accountSid = payload.account_sid; // jshint ignore:line
  this.apiVersion = payload.api_version; // jshint ignore:line
  this.callSid = payload.call_sid; // jshint ignore:line
  this.conferenceSid = payload.conference_sid; // jshint ignore:line
  this.dateCreated = deserialize.rfc2822DateTime(payload.date_created); // jshint ignore:line
  this.dateUpdated = deserialize.rfc2822DateTime(payload.date_updated); // jshint ignore:line
  this.startTime = deserialize.rfc2822DateTime(payload.start_time); // jshint ignore:line
  this.duration = payload.duration; // jshint ignore:line
  this.sid = payload.sid; // jshint ignore:line
  this.price = deserialize.decimal(payload.price); // jshint ignore:line
  this.priceUnit = payload.price_unit; // jshint ignore:line
  this.status = payload.status; // jshint ignore:line
  this.channels = deserialize.integer(payload.channels); // jshint ignore:line
  this.source = payload.source; // jshint ignore:line
  this.errorCode = deserialize.integer(payload.error_code); // jshint ignore:line
  this.encryptionDetails = payload.encryption_details; // jshint ignore:line
  this.uri = payload.uri; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {accountSid: accountSid, conferenceSid: conferenceSid, sid: sid || this.sid, };
};

Object.defineProperty(RecordingInstance.prototype,
  '_proxy', {
    get: function() {
      if (!this._context) {
        this._context = new RecordingContext(
          this._version,
          this._solution.accountSid,
          this._solution.conferenceSid,
          this._solution.sid
        );
      }

      return this._context;
    }
});

/* jshint ignore:start */
/**
 * update a RecordingInstance
 *
 * @function update
 * @memberof Twilio.Api.V2010.AccountContext.ConferenceContext.RecordingInstance#
 *
 * @param {object} opts - Options for request
 * @param {recording.status} opts.status - The new status of the recording
 * @param {string} [opts.pauseBehavior] - Whether to record during a pause
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed RecordingInstance
 */
/* jshint ignore:end */
RecordingInstance.prototype.update = function update(opts, callback) {
  return this._proxy.update(opts, callback);
};

/* jshint ignore:start */
/**
 * fetch a RecordingInstance
 *
 * @function fetch
 * @memberof Twilio.Api.V2010.AccountContext.ConferenceContext.RecordingInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed RecordingInstance
 */
/* jshint ignore:end */
RecordingInstance.prototype.fetch = function fetch(callback) {
  return this._proxy.fetch(callback);
};

/* jshint ignore:start */
/**
 * remove a RecordingInstance
 *
 * @function remove
 * @memberof Twilio.Api.V2010.AccountContext.ConferenceContext.RecordingInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed RecordingInstance
 */
/* jshint ignore:end */
RecordingInstance.prototype.remove = function remove(callback) {
  return this._proxy.remove(callback);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Api.V2010.AccountContext.ConferenceContext.RecordingInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
RecordingInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

RecordingInstance.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the RecordingContext
 *
 * @constructor Twilio.Api.V2010.AccountContext.ConferenceContext.RecordingContext
 *
 * @param {V2010} version - Version of the resource
 * @param {sid} accountSid -
 *          The SID of the Account that created the resource to fetch
 * @param {sid} conferenceSid - Fetch by unique Conference SID for the recording
 * @param {sid} sid - The unique string that identifies the resource
 */
/* jshint ignore:end */
RecordingContext = function RecordingContext(version, accountSid, conferenceSid,
                                              sid) {
  this._version = version;

  // Path Solution
  this._solution = {accountSid: accountSid, conferenceSid: conferenceSid, sid: sid, };
  this._uri = `/Accounts/${accountSid}/Conferences/${conferenceSid}/Recordings/${sid}.json`;
};

/* jshint ignore:start */
/**
 * update a RecordingInstance
 *
 * @function update
 * @memberof Twilio.Api.V2010.AccountContext.ConferenceContext.RecordingContext#
 *
 * @param {object} opts - Options for request
 * @param {recording.status} opts.status - The new status of the recording
 * @param {string} [opts.pauseBehavior] - Whether to record during a pause
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed RecordingInstance
 */
/* jshint ignore:end */
RecordingContext.prototype.update = function update(opts, callback) {
  if (_.isUndefined(opts)) {
    throw new Error('Required parameter "opts" missing.');
  }
  if (_.isUndefined(opts.status)) {
    throw new Error('Required parameter "opts.status" missing.');
  }

  var deferred = Q.defer();
  var data = values.of({
    'Status': _.get(opts, 'status'),
    'PauseBehavior': _.get(opts, 'pauseBehavior')
  });

  var promise = this._version.update({uri: this._uri, method: 'POST', data: data});

  promise = promise.then(function(payload) {
    deferred.resolve(new RecordingInstance(
      this._version,
      payload,
      this._solution.accountSid,
      this._solution.conferenceSid,
      this._solution.sid
    ));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * fetch a RecordingInstance
 *
 * @function fetch
 * @memberof Twilio.Api.V2010.AccountContext.ConferenceContext.RecordingContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed RecordingInstance
 */
/* jshint ignore:end */
RecordingContext.prototype.fetch = function fetch(callback) {
  var deferred = Q.defer();
  var promise = this._version.fetch({uri: this._uri, method: 'GET'});

  promise = promise.then(function(payload) {
    deferred.resolve(new RecordingInstance(
      this._version,
      payload,
      this._solution.accountSid,
      this._solution.conferenceSid,
      this._solution.sid
    ));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * remove a RecordingInstance
 *
 * @function remove
 * @memberof Twilio.Api.V2010.AccountContext.ConferenceContext.RecordingContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed RecordingInstance
 */
/* jshint ignore:end */
RecordingContext.prototype.remove = function remove(callback) {
  var deferred = Q.defer();
  var promise = this._version.remove({uri: this._uri, method: 'DELETE'});

  promise = promise.then(function(payload) {
    deferred.resolve(payload);
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Api.V2010.AccountContext.ConferenceContext.RecordingContext#
 *
 * @returns Object
 */
/* jshint ignore:end */
RecordingContext.prototype.toJSON = function toJSON() {
  return this._solution;
};

RecordingContext.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  RecordingList: RecordingList,
  RecordingPage: RecordingPage,
  RecordingInstance: RecordingInstance,
  RecordingContext: RecordingContext
};
