'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var Page = require('../../../../../base/Page');  /* jshint ignore:line */
var deserialize = require(
    '../../../../../base/deserialize');  /* jshint ignore:line */
var serialize = require(
    '../../../../../base/serialize');  /* jshint ignore:line */
var values = require('../../../../../base/values');  /* jshint ignore:line */

var PaymentList;
var PaymentPage;
var PaymentInstance;
var PaymentContext;

/* jshint ignore:start */
/**
 * Initialize the PaymentList
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Api.V2010.AccountContext.CallContext.PaymentList
 *
 * @param {Twilio.Api.V2010} version - Version of the resource
 * @param {string} accountSid -
 *          The SID of the Account that created the Payments resource.
 * @param {string} callSid - The SID of the Call the resource is associated with.
 */
/* jshint ignore:end */
PaymentList = function PaymentList(version, accountSid, callSid) {
  /* jshint ignore:start */
  /**
   * @function payments
   * @memberof Twilio.Api.V2010.AccountContext.CallContext#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Api.V2010.AccountContext.CallContext.PaymentContext}
   */
  /* jshint ignore:end */
  function PaymentListInstance(sid) {
    return PaymentListInstance.get(sid);
  }

  PaymentListInstance._version = version;
  // Path Solution
  PaymentListInstance._solution = {accountSid: accountSid, callSid: callSid};
  PaymentListInstance._uri = `/Accounts/${accountSid}/Calls/${callSid}/Payments.json`;
  /* jshint ignore:start */
  /**
   * create a PaymentInstance
   *
   * @function create
   * @memberof Twilio.Api.V2010.AccountContext.CallContext.PaymentList#
   *
   * @param {object} opts - Options for request
   * @param {string} opts.idempotencyKey -
   *          A unique token for each payment session that should be provided to maintain idempotency of the session.
   * @param {string} opts.statusCallback -
   *          The URL we should call to send status of payment session.
   * @param {payment.bank_account_type} [opts.bankAccountType] -
   *          If Payment source is ACH, type of bank account.
   * @param {number} [opts.chargeAmount] -
   *          If this field is present and greater than `0.0` payment source will be charged.
   * @param {string} [opts.currency] - Currency `charge_amount` is in.
   * @param {string} [opts.description] - Decription of the charge.
   * @param {string} [opts.input] -
   *          Kind of medium customer would enter payment source information in.
   * @param {number} [opts.minPostalCodeLength] -
   *          If postal code is expected, minimum length of the postal code.
   * @param {object} [opts.parameter] -
   *          Additonal data to be sent over to payment provider.
   * @param {string} [opts.paymentConnector] -
   *          Payment connector that you would like Twilio to use for processing payments.
   * @param {payment.payment_method} [opts.paymentMethod] - Payment source type.
   * @param {boolean} [opts.postalCode] -
   *          Whether to expect postal code during payment source data gathering.
   * @param {boolean} [opts.securityCode] -
   *          Whether to expect security code during payment source data gathering.
   * @param {number} [opts.timeout] -
   *          The number of seconds that we should allow customer to enter payment information
   * @param {payment.token_type} [opts.tokenType] -
   *          If tokenization of payment source is desired, this represents type of token.
   * @param {string} [opts.validCardTypes] -
   *          List of card types accepted with each card types separated by space.
   * @param {function} [callback] - Callback to handle processed record
   *
   * @returns {Promise} Resolves to processed PaymentInstance
   */
  /* jshint ignore:end */
  PaymentListInstance.create = function create(opts, callback) {
    if (_.isUndefined(opts)) {
      throw new Error('Required parameter "opts" missing.');
    }
    if (_.isUndefined(opts.idempotencyKey)) {
      throw new Error('Required parameter "opts.idempotencyKey" missing.');
    }
    if (_.isUndefined(opts.statusCallback)) {
      throw new Error('Required parameter "opts.statusCallback" missing.');
    }

    var deferred = Q.defer();
    var data = values.of({
      'IdempotencyKey': _.get(opts, 'idempotencyKey'),
      'StatusCallback': _.get(opts, 'statusCallback'),
      'BankAccountType': _.get(opts, 'bankAccountType'),
      'ChargeAmount': _.get(opts, 'chargeAmount'),
      'Currency': _.get(opts, 'currency'),
      'Description': _.get(opts, 'description'),
      'Input': _.get(opts, 'input'),
      'MinPostalCodeLength': _.get(opts, 'minPostalCodeLength'),
      'Parameter': serialize.object(_.get(opts, 'parameter')),
      'PaymentConnector': _.get(opts, 'paymentConnector'),
      'PaymentMethod': _.get(opts, 'paymentMethod'),
      'PostalCode': serialize.bool(_.get(opts, 'postalCode')),
      'SecurityCode': serialize.bool(_.get(opts, 'securityCode')),
      'Timeout': _.get(opts, 'timeout'),
      'TokenType': _.get(opts, 'tokenType'),
      'ValidCardTypes': _.get(opts, 'validCardTypes')
    });

    var promise = this._version.create({uri: this._uri, method: 'POST', data: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new PaymentInstance(
        this._version,
        payload,
        this._solution.accountSid,
        this._solution.callSid,
        this._solution.sid
      ));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Constructs a payment
   *
   * @function get
   * @memberof Twilio.Api.V2010.AccountContext.CallContext.PaymentList#
   *
   * @param {string} sid - The SID of Payments session
   *
   * @returns {Twilio.Api.V2010.AccountContext.CallContext.PaymentContext}
   */
  /* jshint ignore:end */
  PaymentListInstance.get = function get(sid) {
    return new PaymentContext(this._version, this._solution.accountSid, this._solution.callSid, sid);
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Api.V2010.AccountContext.CallContext.PaymentList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  PaymentListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  PaymentListInstance[util.inspect.custom] = function inspect(depth, options) {
    return util.inspect(this.toJSON(), options);
  };

  return PaymentListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the PaymentPage
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Api.V2010.AccountContext.CallContext.PaymentPage
 *
 * @param {V2010} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {PaymentSolution} solution - Path solution
 *
 * @returns PaymentPage
 */
/* jshint ignore:end */
PaymentPage = function PaymentPage(version, response, solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(PaymentPage.prototype, Page.prototype);
PaymentPage.prototype.constructor = PaymentPage;

/* jshint ignore:start */
/**
 * Build an instance of PaymentInstance
 *
 * @function getInstance
 * @memberof Twilio.Api.V2010.AccountContext.CallContext.PaymentPage#
 *
 * @param {PaymentPayload} payload - Payload response from the API
 *
 * @returns PaymentInstance
 */
/* jshint ignore:end */
PaymentPage.prototype.getInstance = function getInstance(payload) {
  return new PaymentInstance(
    this._version,
    payload,
    this._solution.accountSid,
    this._solution.callSid
  );
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Api.V2010.AccountContext.CallContext.PaymentPage#
 *
 * @returns Object
 */
/* jshint ignore:end */
PaymentPage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

PaymentPage.prototype[util.inspect.custom] = function inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the PaymentContext
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Api.V2010.AccountContext.CallContext.PaymentInstance
 *
 * @property {string} accountSid -
 *          The SID of the Account that created the Payments resource.
 * @property {string} callSid -
 *          The SID of the Call the resource is associated with.
 * @property {string} sid - The SID of the Payments resource.
 * @property {Date} dateCreated -
 *          The RFC 2822 date and time in GMT that the resource was created
 * @property {Date} dateUpdated -
 *          The RFC 2822 date and time in GMT that the resource was last updated
 * @property {string} uri -
 *          The URI of the resource, relative to `https://api.twilio.com`
 *
 * @param {V2010} version - Version of the resource
 * @param {PaymentPayload} payload - The instance payload
 * @param {sid} accountSid -
 *          The SID of the Account that created the Payments resource.
 * @param {sid} callSid - The SID of the Call the resource is associated with.
 * @param {sid} sid - The SID of Payments session
 */
/* jshint ignore:end */
PaymentInstance = function PaymentInstance(version, payload, accountSid,
                                            callSid, sid) {
  this._version = version;

  // Marshaled Properties
  this.accountSid = payload.account_sid; // jshint ignore:line
  this.callSid = payload.call_sid; // jshint ignore:line
  this.sid = payload.sid; // jshint ignore:line
  this.dateCreated = deserialize.rfc2822DateTime(payload.date_created); // jshint ignore:line
  this.dateUpdated = deserialize.rfc2822DateTime(payload.date_updated); // jshint ignore:line
  this.uri = payload.uri; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {accountSid: accountSid, callSid: callSid, sid: sid || this.sid, };
};

Object.defineProperty(PaymentInstance.prototype,
  '_proxy', {
    get: function() {
      if (!this._context) {
        this._context = new PaymentContext(
          this._version,
          this._solution.accountSid,
          this._solution.callSid,
          this._solution.sid
        );
      }

      return this._context;
    }
});

/* jshint ignore:start */
/**
 * update a PaymentInstance
 *
 * @function update
 * @memberof Twilio.Api.V2010.AccountContext.CallContext.PaymentInstance#
 *
 * @param {object} opts - Options for request
 * @param {string} opts.idempotencyKey -
 *          A unique token for each payment session that should be provided to maintain idempotency of the session.
 * @param {string} opts.statusCallback -
 *          The URL we should call to send status of payment session.
 * @param {payment.capture} [opts.capture] -
 *          Specific payment source information to expect.
 * @param {payment.status} [opts.status] -
 *          Instruction to complete or cancel the transaction.
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed PaymentInstance
 */
/* jshint ignore:end */
PaymentInstance.prototype.update = function update(opts, callback) {
  return this._proxy.update(opts, callback);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Api.V2010.AccountContext.CallContext.PaymentInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
PaymentInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

PaymentInstance.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the PaymentContext
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Api.V2010.AccountContext.CallContext.PaymentContext
 *
 * @param {V2010} version - Version of the resource
 * @param {sid} accountSid - The SID of the Account that will update the resource
 * @param {sid} callSid - The SID of the call that will create the resource.
 * @param {sid} sid - The SID of Payments session
 */
/* jshint ignore:end */
PaymentContext = function PaymentContext(version, accountSid, callSid, sid) {
  this._version = version;

  // Path Solution
  this._solution = {accountSid: accountSid, callSid: callSid, sid: sid, };
  this._uri = `/Accounts/${accountSid}/Calls/${callSid}/Payments/${sid}.json`;
};

/* jshint ignore:start */
/**
 * update a PaymentInstance
 *
 * @function update
 * @memberof Twilio.Api.V2010.AccountContext.CallContext.PaymentContext#
 *
 * @param {object} opts - Options for request
 * @param {string} opts.idempotencyKey -
 *          A unique token for each payment session that should be provided to maintain idempotency of the session.
 * @param {string} opts.statusCallback -
 *          The URL we should call to send status of payment session.
 * @param {payment.capture} [opts.capture] -
 *          Specific payment source information to expect.
 * @param {payment.status} [opts.status] -
 *          Instruction to complete or cancel the transaction.
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed PaymentInstance
 */
/* jshint ignore:end */
PaymentContext.prototype.update = function update(opts, callback) {
  if (_.isUndefined(opts)) {
    throw new Error('Required parameter "opts" missing.');
  }
  if (_.isUndefined(opts.idempotencyKey)) {
    throw new Error('Required parameter "opts.idempotencyKey" missing.');
  }
  if (_.isUndefined(opts.statusCallback)) {
    throw new Error('Required parameter "opts.statusCallback" missing.');
  }

  var deferred = Q.defer();
  var data = values.of({
    'IdempotencyKey': _.get(opts, 'idempotencyKey'),
    'StatusCallback': _.get(opts, 'statusCallback'),
    'Capture': _.get(opts, 'capture'),
    'Status': _.get(opts, 'status')
  });

  var promise = this._version.update({uri: this._uri, method: 'POST', data: data});

  promise = promise.then(function(payload) {
    deferred.resolve(new PaymentInstance(
      this._version,
      payload,
      this._solution.accountSid,
      this._solution.callSid,
      this._solution.sid
    ));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Api.V2010.AccountContext.CallContext.PaymentContext#
 *
 * @returns Object
 */
/* jshint ignore:end */
PaymentContext.prototype.toJSON = function toJSON() {
  return this._solution;
};

PaymentContext.prototype[util.inspect.custom] = function inspect(depth, options)
    {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  PaymentList: PaymentList,
  PaymentPage: PaymentPage,
  PaymentInstance: PaymentInstance,
  PaymentContext: PaymentContext
};
