/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../../base/Page');
import Response = require('../../../../http/response');
import V2010 = require('../../V2010');
import serialize = require('../../../../base/serialize');
import { SerializableClass } from '../../../../interfaces';

/**
 * Initialize the ApplicationList
 *
 * @param version - Version of the resource
 * @param accountSid - The SID of the Account that created the resource
 */
declare function ApplicationList(version: V2010, accountSid: string): ApplicationListInstance;

/**
 * Options to pass to update
 *
 * @property apiVersion - The API version to use to start a new TwiML session
 * @property friendlyName - A string to describe the resource
 * @property messageStatusCallback - The URL to send message status information to your application
 * @property smsFallbackMethod - The HTTP method to use with sms_fallback_url
 * @property smsFallbackUrl - The URL to call when an error occurs while retrieving or executing the TwiML
 * @property smsMethod - The HTTP method to use with sms_url
 * @property smsStatusCallback - The URL to send status information to your application
 * @property smsUrl - The URL to call when the phone number receives an incoming SMS message
 * @property statusCallback - The URL to send status information to your application
 * @property statusCallbackMethod - The HTTP method to use to call status_callback
 * @property voiceCallerIdLookup - Whether to lookup the caller's name
 * @property voiceFallbackMethod - The HTTP method to use with voice_fallback_url
 * @property voiceFallbackUrl - The URL to call when a TwiML error occurs
 * @property voiceMethod - The HTTP method to use with the voice_url
 * @property voiceUrl - The URL to call when the phone number receives a call
 */
interface ApplicationInstanceUpdateOptions {
  apiVersion?: string;
  friendlyName?: string;
  messageStatusCallback?: string;
  smsFallbackMethod?: string;
  smsFallbackUrl?: string;
  smsMethod?: string;
  smsStatusCallback?: string;
  smsUrl?: string;
  statusCallback?: string;
  statusCallbackMethod?: string;
  voiceCallerIdLookup?: boolean;
  voiceFallbackMethod?: string;
  voiceFallbackUrl?: string;
  voiceMethod?: string;
  voiceUrl?: string;
}

interface ApplicationListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): ApplicationContext;
  /**
   * create a ApplicationInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  create(opts?: ApplicationListInstanceCreateOptions, callback?: (error: Error | null, item: ApplicationInstance) => any): Promise<ApplicationInstance>;
  /**
   * Streams ApplicationInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Function to process each record
   */
  each(opts?: ApplicationListInstanceEachOptions, callback?: (item: ApplicationInstance, done: (err?: Error) => void) => void): void;
  /**
   * Constructs a application
   *
   * @param sid - The unique string that identifies the resource
   */
  get(sid: string): ApplicationContext;
  /**
   * Retrieve a single target page of ApplicationInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param targetUrl - API-generated URL for the requested results page
   * @param callback - Callback to handle list of records
   */
  getPage(targetUrl?: string, callback?: (error: Error | null, items: ApplicationPage) => any): Promise<ApplicationPage>;
  /**
   * Lists ApplicationInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  list(opts?: ApplicationListInstanceOptions, callback?: (error: Error | null, items: ApplicationInstance[]) => any): Promise<ApplicationInstance[]>;
  /**
   * Retrieve a single page of ApplicationInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  page(opts?: ApplicationListInstancePageOptions, callback?: (error: Error | null, items: ApplicationPage) => any): Promise<ApplicationPage>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to create
 *
 * @property apiVersion - The API version to use to start a new TwiML session
 * @property friendlyName - A string to describe the new resource
 * @property messageStatusCallback - The URL to send message status information to your application
 * @property smsFallbackMethod - The HTTP method to use with sms_fallback_url
 * @property smsFallbackUrl - The URL to call when an error occurs while retrieving or executing the TwiML
 * @property smsMethod - The HTTP method to use with sms_url
 * @property smsStatusCallback - The URL to send status information to your application
 * @property smsUrl - The URL to call when the phone number receives an incoming SMS message
 * @property statusCallback - The URL to send status information to your application
 * @property statusCallbackMethod - The HTTP method to use to call status_callback
 * @property voiceCallerIdLookup - Whether to lookup the caller's name
 * @property voiceFallbackMethod - The HTTP method to use with voice_fallback_url
 * @property voiceFallbackUrl - The URL to call when a TwiML error occurs
 * @property voiceMethod - The HTTP method to use with the voice_url
 * @property voiceUrl - The URL to call when the phone number receives a call
 */
interface ApplicationListInstanceCreateOptions {
  apiVersion?: string;
  friendlyName?: string;
  messageStatusCallback?: string;
  smsFallbackMethod?: string;
  smsFallbackUrl?: string;
  smsMethod?: string;
  smsStatusCallback?: string;
  smsUrl?: string;
  statusCallback?: string;
  statusCallbackMethod?: string;
  voiceCallerIdLookup?: boolean;
  voiceFallbackMethod?: string;
  voiceFallbackUrl?: string;
  voiceMethod?: string;
  voiceUrl?: string;
}

/**
 * Options to pass to each
 *
 * @property callback -
 *                         Function to process each record. If this and a positional
 *                         callback are passed, this one will be used
 * @property done - Function to be called upon completion of streaming
 * @property friendlyName - The string that identifies the Application resources to read
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         each() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no pageSize is defined but a limit is defined,
 *                         each() will attempt to read the limit with the most efficient
 *                         page size, i.e. min(limit, 1000)
 */
interface ApplicationListInstanceEachOptions {
  callback?: (item: ApplicationInstance, done: (err?: Error) => void) => void;
  done?: Function;
  friendlyName?: string;
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to list
 *
 * @property friendlyName - The string that identifies the Application resources to read
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         list() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no page_size is defined but a limit is defined,
 *                         list() will attempt to read the limit with the most
 *                         efficient page size, i.e. min(limit, 1000)
 */
interface ApplicationListInstanceOptions {
  friendlyName?: string;
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to page
 *
 * @property friendlyName - The string that identifies the Application resources to read
 * @property pageNumber - Page Number, this value is simply for client state
 * @property pageSize - Number of records to return, defaults to 50
 * @property pageToken - PageToken provided by the API
 */
interface ApplicationListInstancePageOptions {
  friendlyName?: string;
  pageNumber?: number;
  pageSize?: number;
  pageToken?: string;
}

interface ApplicationPayload extends ApplicationResource, Page.TwilioResponsePayload {
}

interface ApplicationResource {
  account_sid: string;
  api_version: string;
  date_created: Date;
  date_updated: Date;
  friendly_name: string;
  message_status_callback: string;
  sid: string;
  sms_fallback_method: string;
  sms_fallback_url: string;
  sms_method: string;
  sms_status_callback: string;
  sms_url: string;
  status_callback: string;
  status_callback_method: string;
  uri: string;
  voice_caller_id_lookup: boolean;
  voice_fallback_method: string;
  voice_fallback_url: string;
  voice_method: string;
  voice_url: string;
}

interface ApplicationSolution {
  accountSid?: string;
}


declare class ApplicationContext {
  /**
   * Initialize the ApplicationContext
   *
   * @param version - Version of the resource
   * @param accountSid - The SID of the Account that created the resource to fetch
   * @param sid - The unique string that identifies the resource
   */
  constructor(version: V2010, accountSid: string, sid: string);

  /**
   * fetch a ApplicationInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: ApplicationInstance) => any): Promise<ApplicationInstance>;
  /**
   * remove a ApplicationInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: ApplicationInstance) => any): Promise<boolean>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a ApplicationInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: ApplicationInstanceUpdateOptions, callback?: (error: Error | null, items: ApplicationInstance) => any): Promise<ApplicationInstance>;
}


declare class ApplicationInstance extends SerializableClass {
  /**
   * Initialize the ApplicationContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param accountSid - The SID of the Account that created the resource
   * @param sid - The unique string that identifies the resource
   */
  constructor(version: V2010, payload: ApplicationPayload, accountSid: string, sid: string);

  private _proxy: ApplicationContext;
  accountSid: string;
  apiVersion: string;
  dateCreated: Date;
  dateUpdated: Date;
  /**
   * fetch a ApplicationInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: ApplicationInstance) => any): Promise<ApplicationInstance>;
  friendlyName: string;
  messageStatusCallback: string;
  /**
   * remove a ApplicationInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: ApplicationInstance) => any): Promise<boolean>;
  sid: string;
  smsFallbackMethod: string;
  smsFallbackUrl: string;
  smsMethod: string;
  smsStatusCallback: string;
  smsUrl: string;
  statusCallback: string;
  statusCallbackMethod: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a ApplicationInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: ApplicationInstanceUpdateOptions, callback?: (error: Error | null, items: ApplicationInstance) => any): Promise<ApplicationInstance>;
  uri: string;
  voiceCallerIdLookup: boolean;
  voiceFallbackMethod: string;
  voiceFallbackUrl: string;
  voiceMethod: string;
  voiceUrl: string;
}


declare class ApplicationPage extends Page<V2010, ApplicationPayload, ApplicationResource, ApplicationInstance> {
  /**
   * Initialize the ApplicationPage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V2010, response: Response<string>, solution: ApplicationSolution);

  /**
   * Build an instance of ApplicationInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: ApplicationPayload): ApplicationInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { ApplicationContext, ApplicationInstance, ApplicationInstanceUpdateOptions, ApplicationList, ApplicationListInstance, ApplicationListInstanceCreateOptions, ApplicationListInstanceEachOptions, ApplicationListInstanceOptions, ApplicationListInstancePageOptions, ApplicationPage, ApplicationPayload, ApplicationResource, ApplicationSolution }
