'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var _ = require('lodash');  /* jshint ignore:line */
var Domain = require('../base/Domain');  /* jshint ignore:line */
var V1 = require('./fax/V1');  /* jshint ignore:line */


/* jshint ignore:start */
/**
 * Initialize fax domain
 *
 * @constructor Twilio.Fax
 *
 * @property {Twilio.Fax.V1} v1 - v1 version
 * @property {Twilio.Fax.V1.FaxList} faxes - faxes resource
 *
 * @param {Twilio} twilio - The twilio client
 */
/* jshint ignore:end */
function Fax(twilio) {
  Domain.prototype.constructor.call(this, twilio, 'https://fax.twilio.com');

  // Versions
  this._v1 = undefined;
}

_.extend(Fax.prototype, Domain.prototype);
Fax.prototype.constructor = Fax;

Object.defineProperty(Fax.prototype,
  'v1', {
    get: function() {
      this._v1 = this._v1 || new V1(this);
      return this._v1;
    }
});

Object.defineProperty(Fax.prototype,
  'faxes', {
    get: function() {
      return this.v1.faxes;
    }
});

module.exports = Fax;
